package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.service.api.DycActQueryActivityChangePageListService;
import com.tydic.dyc.act.service.bo.DycActQueryActivityChangePageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivityChangePageListRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 说明：活动变更列表查询（分页）服务
 *
 * @author zhoulu
 * @date 2023年12月27日 14:50
 */
@HTServiceImpl
public class DycActQueryActivityChangePageListServiceImpl implements DycActQueryActivityChangePageListService {
    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;

    @Override
    public DycActQueryActivityChangePageListRspBO queryActivityChangePageList(DycActQueryActivityChangePageListReqBO reqBO) {
        DycActivityChangeDO dycActivityChangeDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityChangeDO.class);
        DycActQueryActivityChangePageListRspBO rspBO = JSON.parseObject(JSON.toJSONString(dycActivityChangeModel.queryActivityChangePageList(dycActivityChangeDO)), DycActQueryActivityChangePageListRspBO.class);
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
