package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.model.bo.DycActivityChangeSupplierInfo;
import com.tydic.dyc.act.service.api.DycActQueryActivityChangeSelectedSupplierPageListService;
import com.tydic.dyc.act.service.bo.DycActQueryActivityChangeSelectedSupplierPageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivityChangeSelectedSupplierPageListRspBO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 说明：活动变更已选供应商列表查询（分页）服务
 *
 * @author zhoulu
 * @date 2023年12月22日 14:17
 */
@HTServiceImpl
public class DycActQueryActivityChangeSelectedSupplierPageListServiceImpl implements DycActQueryActivityChangeSelectedSupplierPageListService {

    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;

    @Override
    public DycActQueryActivityChangeSelectedSupplierPageListRspBO queryActivityChangeSelectedSupplierPageList(DycActQueryActivityChangeSelectedSupplierPageListReqBO reqBO) {
        if (reqBO.getChangeId() == null){
            throw new ZTBusinessException("变更单id不能为空");
        }
        DycActivityChangeDO dycActivityChangeDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityChangeDO.class);
        BasePageRspBo<DycActivityChangeSupplierInfo> rspBo = dycActivityChangeModel.queryActivityChangeSelectedSupplierPageList(dycActivityChangeDO);
        DycActQueryActivityChangeSelectedSupplierPageListRspBO rspBO = JSON.parseObject(JSON.toJSONString(rspBo),DycActQueryActivityChangeSelectedSupplierPageListRspBO.class );
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
