package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.service.api.DycActQueryActivityChangeUserListService;
import com.tydic.dyc.act.service.bo.*;
import com.tydic.dyc.act.utils.ActRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 类名： DycActQueryActivityChangeUserListServiceImpl
 * 说明：
 *
 * @author： lishiqing
 * 时间： 2024/4/18 20:34
 */
@HTServiceImpl
public class DycActQueryActivityChangeUserListServiceImpl implements DycActQueryActivityChangeUserListService {

    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;

    @Override
    public DycActQueryActivityChangeUserListRspBO queryActivityChangeUserList(DycActQueryActivityChangeUserListReqBO reqBO) {
        if (reqBO.getChangeId() == null) {
            throw new ZTBusinessException("变更单ID不能为空！");
        }
        DycActQueryActivityChangeUserListRspBO rspBO = ActRu.success(DycActQueryActivityChangeUserListRspBO.class);
        DycActivityChangeDO dycActivityDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityChangeDO.class);
        rspBO.setRows(ActRu.jsl(dycActivityChangeModel.queryChangeActivityUserList(dycActivityDO), ActivityChangeUserInfoBO.class));
        return rspBO;
    }
}
