package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.ActivityChangeUserInfo;
import com.tydic.dyc.act.model.bo.ActivityChangeUserInfoQryBO;
import com.tydic.dyc.act.service.api.DycActQueryActivityChangeUserPageListService;
import com.tydic.dyc.act.service.bo.DycActQueryActivityChangeUserPageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivityChangeUserPageListRspBO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActQueryActivityChangeUserPageListServiceImpl
 * 说明：活动变更已选用户列表查询（分页）服务
 * 时间： 2023-12-25 21:01
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActQueryActivityChangeUserPageListServiceImpl implements DycActQueryActivityChangeUserPageListService {

    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;

    @Override
    public DycActQueryActivityChangeUserPageListRspBO queryActivityChangeUserPageList(DycActQueryActivityChangeUserPageListReqBO reqBo) {
        ActivityChangeUserInfoQryBO qryBo = JSON.parseObject(JSON.toJSONString(reqBo), ActivityChangeUserInfoQryBO.class);
        BasePageRspBo<ActivityChangeUserInfo> catalogInfoBasePageRspBo = dycActivityChangeModel.queryActivityChangeUserPageList(qryBo);
        return JSON.parseObject(JSON.toJSONString(catalogInfoBasePageRspBo), DycActQueryActivityChangeUserPageListRspBO.class);
    }
}
