package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActQueryActivityCommodityListService;
import com.tydic.dyc.act.service.bo.DycActActivityCommodityInfoBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivityCommodityPageListReqBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题：DycActQueryActivityCommodityListServiceImpl
 * 说明：
 * 时间： 2024-04-16 10:08
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActQueryActivityCommodityListServiceImpl implements DycActQueryActivityCommodityListService {
    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public List<DycActActivityCommodityInfoBO> queryActivityCommodityList(DycActQueryActivityCommodityPageListReqBO reqBO) {
        DycActivityDO dycActivityDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityDO.class);
        return JSON.parseArray(JSON.toJSONString(dycActActivityModel.queryActivityCommodityList(dycActivityDO)), DycActActivityCommodityInfoBO.class);
    }
}
