package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityCommodityPoolInfo;
import com.tydic.dyc.act.model.bo.DycQueryActivityCommodityPoolPageListReqBO;
import com.tydic.dyc.act.service.api.DycActQueryActivityCommodityPoolPageListService;
import com.tydic.dyc.act.service.bo.DycActQueryActivityCommodityPoolPageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivityCommodityPoolPageListRspBO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActQueryActivityCommodityPoolPageListServiceImpl
 * 说明： 活动已选商品池列表分页查询
 * 时间： 2023-12-13 15:34
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActQueryActivityCommodityPoolPageListServiceImpl implements DycActQueryActivityCommodityPoolPageListService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActQueryActivityCommodityPoolPageListRspBO queryActivityCommodityPoolPageList(DycActQueryActivityCommodityPoolPageListReqBO reqBO) {

        DycQueryActivityCommodityPoolPageListReqBO dycQueryActivityCommodityPoolPageListReqBO = JSON.parseObject(JSON.toJSONString(reqBO), DycQueryActivityCommodityPoolPageListReqBO.class);

        BasePageRspBo<DycActivityCommodityPoolInfo> dycActivityCommodityPoolInfoBasePageRspBo = dycActActivityModel.queryActivityCommodityPoolPageList(dycQueryActivityCommodityPoolPageListReqBO);

        DycActQueryActivityCommodityPoolPageListRspBO rspBO = JSON.parseObject(JSON.toJSONString(dycActivityCommodityPoolInfoBasePageRspBo), DycActQueryActivityCommodityPoolPageListRspBO.class);

        return rspBO;
    }
}
