package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityBaseInfo;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActQueryActivityPageListService;
import com.tydic.dyc.act.service.bo.DycActQueryActivityPageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivityPageListRspBO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/**
 * 标题：DycActActiveListQueryServiceImpl
 * 说明：活动列表查询服务
 * 时间： 2023-12-12 16:15
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActQueryActivityPageListServiceImpl implements DycActQueryActivityPageListService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActQueryActivityPageListRspBO queryActivityPageList(DycActQueryActivityPageListReqBO reqBO) {
        DycActivityDO queryBO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityDO.class);
        BasePageRspBo<DycActivityBaseInfo> basePageRspBo = dycActActivityModel.queryActivityPageList(queryBO);
        DycActQueryActivityPageListRspBO rspBO = JSON.parseObject(JSON.toJSONString(basePageRspBo), DycActQueryActivityPageListRspBO.class);
        return rspBO;
    }
}
