package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActSceneInfo;
import com.tydic.dyc.act.model.bo.DycActSceneInfoDO;
import com.tydic.dyc.act.service.api.DycActQueryActivitySceneService;
import com.tydic.dyc.act.service.bo.DycActActivitySceneInfoBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivitySceneReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivitySceneRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题：DycActQueryActivitySceneServiceImpl
 * 说明：
 * 时间： 2024-03-28 15:08
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActQueryActivitySceneServiceImpl implements DycActQueryActivitySceneService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActQueryActivitySceneRspBO queryActivityScene(DycActQueryActivitySceneReqBO reqBO) {
        DycActSceneInfoDO reqDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActSceneInfoDO.class);
        List<DycActSceneInfo> dycActSceneInfos = dycActActivityModel.queryActivityScene(reqDO);
        DycActQueryActivitySceneRspBO rspBO = new DycActQueryActivitySceneRspBO();
        rspBO.setRows(JSON.parseArray(JSON.toJSONString(dycActSceneInfos), DycActActivitySceneInfoBO.class));
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
