package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActQueryActivitySelectableSupplierListService;
import com.tydic.dyc.act.service.bo.DycActActivitySupplierInfoBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivitySelectableSupplierListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivitySelectableSupplierListRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题：DycActQueryActivitySelectableSupplierListServiceImpl
 * 说明：
 * 时间： 2024-04-01 18:16
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActQueryActivitySelectableSupplierListServiceImpl implements DycActQueryActivitySelectableSupplierListService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActQueryActivitySelectableSupplierListRspBO queryActivitySelectableSupplierList(DycActQueryActivitySelectableSupplierListReqBO reqBO) {
        DycActivityDO dycActivityDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityDO.class);
        List<DycActActivitySupplierInfoBO> infoBOS = JSON.parseArray(JSON.toJSONString(dycActActivityModel.queryActivitySelectableSupplierList(dycActivityDO)), DycActActivitySupplierInfoBO.class);
        DycActQueryActivitySelectableSupplierListRspBO rspBO = new DycActQueryActivitySelectableSupplierListRspBO();
        rspBO.setRows(infoBOS);
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
