package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.ActActivitySyncExternalRecordDO;
import com.tydic.dyc.act.service.api.DycActQueryActivitySyncExternalRecordService;
import com.tydic.dyc.act.service.bo.DycActActivitySyncExternalRecordReqBO;
import com.tydic.dyc.act.service.bo.DycActActivitySyncExternalRecordRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActQueryActivitySyncExternalRecordServiceImpl
 * 说明：
 * 时间： 2024-04-12 14:31
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActQueryActivitySyncExternalRecordServiceImpl implements DycActQueryActivitySyncExternalRecordService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActActivitySyncExternalRecordRspBO queryActivitySyncExternalRecordSingle(DycActActivitySyncExternalRecordReqBO reqBO) {
        ActActivitySyncExternalRecordDO dycActivityDO = JSON.parseObject(JSON.toJSONString(reqBO), ActActivitySyncExternalRecordDO.class);
        DycActActivitySyncExternalRecordRspBO rspBO = JSON.parseObject(JSON.toJSONString(dycActActivityModel.queryActivitySyncExternalRecordSingle(dycActivityDO)), DycActActivitySyncExternalRecordRspBO.class);
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
