package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.ActActivitySyncExternalRecordDO;
import com.tydic.dyc.act.model.bo.ActActivitySyncExternalRecordInfo;
import com.tydic.dyc.act.service.api.DycActQueryActivitySyncRecordListService;
import com.tydic.dyc.act.service.bo.DycActActivitySyncRecordInfoBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivitySyncRecordListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivitySyncRecordListRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题：DycActQueryActivitySyncRecordListServiceImpl
 * 说明：
 * 时间： 2024-04-17 20:02
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActQueryActivitySyncRecordListServiceImpl implements DycActQueryActivitySyncRecordListService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActQueryActivitySyncRecordListRspBO queryActivitySyncRecordList(DycActQueryActivitySyncRecordListReqBO reqBO) {

        ActActivitySyncExternalRecordDO recordDO = new ActActivitySyncExternalRecordDO();
        recordDO.setObjId(reqBO.getActivityId());
        List<ActActivitySyncExternalRecordInfo> recordInfos = dycActActivityModel.queryActivitySyncExternalRecordList(recordDO);
        DycActQueryActivitySyncRecordListRspBO rspBO = new DycActQueryActivitySyncRecordListRspBO();
        List<DycActActivitySyncRecordInfoBO> bos = JSON.parseArray(JSON.toJSONString(recordInfos), DycActActivitySyncRecordInfoBO.class);
        rspBO.setRows(bos);
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
