package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActQueryActivityUserListService;
import com.tydic.dyc.act.service.bo.DycActActivityUserInfoBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivityUserListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivityUserListRspBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivityUserPageListRspBO;
import com.tydic.dyc.act.utils.ActRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 类名： DycActQueryActivityUserListServiceImpl
 * 说明：活动已选用户列表查询实现
 *
 * @author： lishiqing
 * 时间： 2024/4/15 17:42
 */
@HTServiceImpl
public class DycActQueryActivityUserListServiceImpl implements DycActQueryActivityUserListService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActQueryActivityUserListRspBO queryActivityUserList(DycActQueryActivityUserListReqBO reqBO) {
        if (reqBO.getActivityId() == null) {
            throw new ZTBusinessException("活动id不能为空！");
        }
        DycActQueryActivityUserListRspBO rspBO = ActRu.success(DycActQueryActivityUserListRspBO.class);
        DycActivityDO dycActivityDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityDO.class);
        rspBO.setRows(ActRu.jsl(dycActActivityModel.queryActivityUserList(dycActivityDO),DycActActivityUserInfoBO.class));
        return rspBO;
    }
}
