package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActQueryActivityUserScoresUseRecordPageListService;
import com.tydic.dyc.act.service.bo.DycActQueryActivityUserScoresUseRecordPageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivityUserScoresUseRecordPageListRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 说明：活动用户积分流水查询（分页）服务
 *
 * @author zhoulu
 * @date 2023年12月27日 16:12
 */
@HTServiceImpl
public class DycActQueryActivityUserScoresUseRecordPageListServiceImpl implements DycActQueryActivityUserScoresUseRecordPageListService {
    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActQueryActivityUserScoresUseRecordPageListRspBO queryActivityUserScoresUseRecordPageList(DycActQueryActivityUserScoresUseRecordPageListReqBO reqBO) {
        DycActivityDO dycActivityDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityDO.class);
        DycActQueryActivityUserScoresUseRecordPageListRspBO rspBO = JSON.parseObject(JSON.toJSONString(dycActActivityModel.queryActivityUserScoresUseRecordPageList(dycActivityDO)), DycActQueryActivityUserScoresUseRecordPageListRspBO.class);
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
