package com.tydic.dyc.act.service.impl;

import com.tydic.dyc.act.model.api.DycActOrderModel;
import com.tydic.dyc.act.model.bo.DycActOrderAfsInfo;
import com.tydic.dyc.act.model.bo.DycActOrderAfsQryDO;
import com.tydic.dyc.act.service.api.DycActQueryAfsOrderPageListService;
import com.tydic.dyc.act.service.bo.DycActAfsOrderInfoBO;
import com.tydic.dyc.act.service.bo.DycActQueryAfsOrderPageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryAfsOrderPageListRspBO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @ClassName DycActQueryAfsOrderPageListServiceImpl
 * @Author 14051
 * @Date 2024/4/9 15:35
 * @Version 1.0
 * @Description 服务单列表查询实现类
 **/
@HTServiceImpl
public class DycActQueryAfsOrderPageListServiceImpl implements DycActQueryAfsOrderPageListService {

    @Autowired
    private DycActOrderModel dycActOrderModel;

    @Override
    public DycActQueryAfsOrderPageListRspBO queryAfsOrderPageList(DycActQueryAfsOrderPageListReqBO reqBO) {
        DycActQueryAfsOrderPageListRspBO rspBO = new DycActQueryAfsOrderPageListRspBO();
        DycActOrderAfsQryDO dycActOrderAfsQryDO = new DycActOrderAfsQryDO();
        BeanUtils.copyProperties(reqBO, dycActOrderAfsQryDO);
        dycActOrderAfsQryDO.setAlertType(reqBO.getAlertState());
        BasePageRspBo<DycActOrderAfsInfo> dycActOrderInfoBasePageRspBo = dycActOrderModel.qryOrdAfsInfoPageList(dycActOrderAfsQryDO);
        if (dycActOrderInfoBasePageRspBo != null) {
            rspBO.setPageNo(dycActOrderInfoBasePageRspBo.getPageNo());
            rspBO.setRecordsTotal(dycActOrderInfoBasePageRspBo.getRecordsTotal());
            rspBO.setTotal(dycActOrderInfoBasePageRspBo.getTotal());
            if (!CollectionUtils.isEmpty(dycActOrderInfoBasePageRspBo.getRows())) {
                List<DycActAfsOrderInfoBO> dycActOrderInfoBOList = dycActOrderInfoBasePageRspBo.getRows().stream().map(bo -> {
                    DycActAfsOrderInfoBO dycActOrderInfoBO = new DycActAfsOrderInfoBO();
                    BeanUtils.copyProperties(bo, dycActOrderInfoBO);
                    return dycActOrderInfoBO;
                }).collect(Collectors.toList());
                rspBO.setRows(dycActOrderInfoBOList);
            }
        }
        return rspBO;
    }
}
