package com.tydic.dyc.act.service.impl;

import com.tydic.dyc.act.model.api.DycActGuideModel;
import com.tydic.dyc.act.model.bo.DycActGuideDO;
import com.tydic.dyc.act.model.bo.DycActGuideQryDO;
import com.tydic.dyc.act.service.api.DycActQueryCatalogTreeService;
import com.tydic.dyc.act.service.bo.DycActQueryCatalogTreeBO;
import com.tydic.dyc.act.service.bo.DycActQueryCatalogTreeReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryCatalogTreeRspBO;
import com.tydic.dyc.base.utils.JUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题：DycActQueryCatalogTreeServiceImpl
 * 说明：
 * 时间：2024/4/9 19:38
 * 作者：Zhouhaifeng
 */
@HTServiceImpl
public class DycActQueryCatalogTreeServiceImpl implements DycActQueryCatalogTreeService {

    @Autowired
    private DycActGuideModel dycActGuideModel;

    @Override
    public DycActQueryCatalogTreeRspBO queryCatalogTree(DycActQueryCatalogTreeReqBO reqBO) {
        DycActQueryCatalogTreeRspBO rspBO = new DycActQueryCatalogTreeRspBO();
        DycActGuideQryDO qryDO = new DycActGuideQryDO();
        qryDO.setPoolId(reqBO.getPoolId());
        qryDO.setExitStatus(reqBO.isExitStatus());
        DycActGuideDO dycActGuideDO = dycActGuideModel.queryCatalogTree(qryDO);
        List<DycActQueryCatalogTreeBO> catalogTreeList = JUtil.jsl(dycActGuideDO.getCatalogTreeList(),DycActQueryCatalogTreeBO.class);
        rspBO.setCatalogTreeList(catalogTreeList);
        return rspBO;
    }
}
