package com.tydic.dyc.act.service.impl;

import com.tydic.dyc.act.model.api.DycActFscInvoiceModel;
import com.tydic.dyc.act.model.bo.DycActFscInvoiceDO;
import com.tydic.dyc.act.model.bo.DycActFscInvoiceInfo;
import com.tydic.dyc.act.model.bo.DycActFscInvoiceItemInfo;
import com.tydic.dyc.act.service.api.DycActQueryFscInvoiceItemPageListService;
import com.tydic.dyc.act.service.bo.DycActFscInvoiceItemInfoBO;
import com.tydic.dyc.act.service.bo.DycActQueryFscInvoiceItemPageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryFscInvoiceItemPageListRspBO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @ClassName DycActQueryFscInvoiceItemPageListServiceImpl
 * @Author 14051
 * @Date 2024/4/3 11:20
 * @Version 1.0
 * @Description TODO
 **/
@HTServiceImpl
public class DycActQueryFscInvoiceItemPageListServiceImpl implements DycActQueryFscInvoiceItemPageListService {

    @Autowired
    private DycActFscInvoiceModel dycActFscInvoiceModel;

    @Override
    public DycActQueryFscInvoiceItemPageListRspBO queryFscInvoiceItemPageList(DycActQueryFscInvoiceItemPageListReqBO reqBO) {
        //查询发票ID
        DycActFscInvoiceDO dycActFscInvoiceDO = new DycActFscInvoiceDO();
        BeanUtils.copyProperties(reqBO, dycActFscInvoiceDO);
        DycActFscInvoiceInfo dycActFscInvoiceInfo = dycActFscInvoiceModel.getInvoiceInfoByInvoiceNo(dycActFscInvoiceDO);
        if (dycActFscInvoiceInfo == null){
            return new DycActQueryFscInvoiceItemPageListRspBO();
        }
        DycActQueryFscInvoiceItemPageListRspBO rspBO = new DycActQueryFscInvoiceItemPageListRspBO();
        //查询发票明细数据
        DycActFscInvoiceDO qryItemDO = new DycActFscInvoiceDO();
        qryItemDO.setFscOrderId(reqBO.getFscOrderId());
        qryItemDO.setInvoiceId(dycActFscInvoiceInfo.getInvoiceId());
        qryItemDO.setPageNo(reqBO.getPageNo());
        qryItemDO.setPageSize(reqBO.getPageSize());
        BasePageRspBo<DycActFscInvoiceItemInfo> dycActFscInvoiceItemInfoBasePageRspBo = dycActFscInvoiceModel.qryInvoiceItemList(qryItemDO);
        if (dycActFscInvoiceItemInfoBasePageRspBo != null) {
            rspBO.setPageNo(dycActFscInvoiceItemInfoBasePageRspBo.getPageNo());
            rspBO.setRecordsTotal(dycActFscInvoiceItemInfoBasePageRspBo.getRecordsTotal());
            rspBO.setTotal(dycActFscInvoiceItemInfoBasePageRspBo.getTotal());
            if (!CollectionUtils.isEmpty(dycActFscInvoiceItemInfoBasePageRspBo.getRows())) {
                List<DycActFscInvoiceItemInfoBO> dycActOrderInfoBOList = new ArrayList<>();
                dycActFscInvoiceItemInfoBasePageRspBo.getRows().forEach(bo -> {
                    DycActFscInvoiceItemInfoBO dycActOrderInfoBO = new DycActFscInvoiceItemInfoBO();
                    BeanUtils.copyProperties(bo, dycActOrderInfoBO);
                    dycActOrderInfoBO.setInvoiceNo(reqBO.getInvoiceNo());
                    dycActOrderInfoBO.setInvoiceCode(reqBO.getInvoiceCode());
                    dycActOrderInfoBOList.add(dycActOrderInfoBO);
                });
                rspBO.setRows(dycActOrderInfoBOList);
            }
        }
        return rspBO;
    }
}
