package com.tydic.dyc.act.service.impl;

import com.tydic.dyc.act.model.api.DycActFscInvoiceModel;
import com.tydic.dyc.act.model.bo.DycActFscInvoiceDO;
import com.tydic.dyc.act.model.bo.DycActFscInvoiceInfo;
import com.tydic.dyc.act.service.api.DycActQueryFscInvoicePageListService;
import com.tydic.dyc.act.service.bo.DycActFscInvoiceInfoBO;
import com.tydic.dyc.act.service.bo.DycActQueryFscInvoicePageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryFscInvoicePageListRspBO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @ClassName DycActQueryFscInvoicePageListServiceImpl
 * @Author 14051
 * @Date 2024/4/3 14:54
 * @Version 1.0
 * @Description TODO
 **/
@HTServiceImpl
public class DycActQueryFscInvoicePageListServiceImpl implements DycActQueryFscInvoicePageListService {

    @Autowired
    private DycActFscInvoiceModel dycActFscInvoiceModel;

    @Override
    public DycActQueryFscInvoicePageListRspBO queryFscInvoicePageList(DycActQueryFscInvoicePageListReqBO reqBO) {
        DycActQueryFscInvoicePageListRspBO rspBO = new DycActQueryFscInvoicePageListRspBO();
        DycActFscInvoiceDO dycActFscInvoiceDO = new DycActFscInvoiceDO();
        BeanUtils.copyProperties(reqBO, dycActFscInvoiceDO);
        BasePageRspBo<DycActFscInvoiceInfo> dycActFscInvoiceInfoBasePageRspBo = dycActFscInvoiceModel.qryInvoiceList(dycActFscInvoiceDO);
        if (dycActFscInvoiceInfoBasePageRspBo != null) {
            rspBO.setPageNo(dycActFscInvoiceInfoBasePageRspBo.getPageNo());
            rspBO.setRecordsTotal(dycActFscInvoiceInfoBasePageRspBo.getRecordsTotal());
            rspBO.setTotal(dycActFscInvoiceInfoBasePageRspBo.getTotal());
            if (!CollectionUtils.isEmpty(dycActFscInvoiceInfoBasePageRspBo.getRows())) {
                List<DycActFscInvoiceInfoBO> dycActOrderInfoBOList = new ArrayList<>();
                dycActFscInvoiceInfoBasePageRspBo.getRows().forEach(bo -> {
                    DycActFscInvoiceInfoBO dycActOrderInfoBO = new DycActFscInvoiceInfoBO();
                    BeanUtils.copyProperties(bo, dycActOrderInfoBO);
                    dycActOrderInfoBO.setInvoiceDate(bo.getBillDate());
                    dycActOrderInfoBOList.add(dycActOrderInfoBO);
                });
                rspBO.setRows(dycActOrderInfoBOList);
            }
        }

        return rspBO;
    }
}
