package com.tydic.dyc.act.service.impl;

import com.tydic.dyc.act.model.api.DycActFscOrderModel;
import com.tydic.dyc.act.model.bo.DycActFscOrderDO;
import com.tydic.dyc.act.model.bo.DycActFscOrderInfo;
import com.tydic.dyc.act.model.bo.DycActFscOrderInvoiceInfo;
import com.tydic.dyc.act.service.api.DycActQueryFscOrderDetailService;
import com.tydic.dyc.act.service.bo.DycActFscOrderInvoiceBO;
import com.tydic.dyc.act.service.bo.DycActQueryFscOrderDetailReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryFscOrderDetailRspBO;
import com.tydic.dyc.base.utils.JUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @ClassName DycActQueryFscOrderDetailServiceImpl
 * @Author 14051
 * @Date 2024/4/4 11:42
 * @Version 1.0
 * @Description TODO
 **/
@Slf4j
@HTServiceImpl
public class DycActQueryFscOrderDetailServiceImpl implements DycActQueryFscOrderDetailService {

    @Autowired
    private DycActFscOrderModel dycActFscOrderModel;

    @Override
    public DycActQueryFscOrderDetailRspBO queryFscOrderDetail(DycActQueryFscOrderDetailReqBO reqBO) {
        DycActQueryFscOrderDetailRspBO rspBO = new DycActQueryFscOrderDetailRspBO();
        //1、查询结算单基本信息
        DycActFscOrderDO dycActFscOrderQryDO = new DycActFscOrderDO();
        dycActFscOrderQryDO.setFscOrderId(reqBO.getFscOrderId());
        DycActFscOrderInfo dycActFscOrderInfo = dycActFscOrderModel.getFscOrderOne(dycActFscOrderQryDO);
        if (dycActFscOrderInfo == null){
            return rspBO;
        }
        rspBO = JUtil.js(dycActFscOrderInfo,DycActQueryFscOrderDetailRspBO.class);
        rspBO.setActivityScopeName(dycActFscOrderInfo.getActivityScopeOrgName());

        //2、查询订单数量
        DycActFscOrderDO qryNumDO = new DycActFscOrderDO();
        qryNumDO.setFscOrderId(reqBO.getFscOrderId());
        Integer orderNum = dycActFscOrderModel.getFscOrderNum(qryNumDO);
        rspBO.setOrderNum(orderNum);
        //3、查询发票信息
        DycActFscOrderDO qryOrdInvoice = new DycActFscOrderDO();
        qryOrdInvoice.setFscOrderId(reqBO.getFscOrderId());
        DycActFscOrderInvoiceInfo dycActFscOrderInvoiceInfo = dycActFscOrderModel.selectOneFscOrderInvoice(qryOrdInvoice);
        rspBO.setOrderInvoice(JUtil.js(dycActFscOrderInvoiceInfo, DycActFscOrderInvoiceBO.class));

        return rspBO;
    }
}
