package com.tydic.dyc.act.service.impl;

import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActFscOrderModel;
import com.tydic.dyc.act.model.bo.DycActFscOrderInfo;
import com.tydic.dyc.act.model.bo.DycActFscOrderQryDO;
import com.tydic.dyc.act.service.api.DycActQueryFscOrderListService;
import com.tydic.dyc.act.service.bo.DycActFscOrderInfoBO;
import com.tydic.dyc.act.service.bo.DycActQueryFscOrderListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryFscOrderListRspBO;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.base.bo.BasePageRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题：DycActQueryFscOrderListServiceImpl
 * 说明：无
 * 时间：2024/4/25
 *
 * @author zhoujie
 */
@HTServiceImpl
public class DycActQueryFscOrderListServiceImpl implements DycActQueryFscOrderListService {

    @Autowired
    private DycActFscOrderModel dycActFscOrderModel;
    @Override
    public DycActQueryFscOrderListRspBO queryFscOrderList(DycActQueryFscOrderListReqBO reqBo) {
        DycActFscOrderQryDO dycActFscOrderQryDo = ActRu.js(reqBo, DycActFscOrderQryDO.class);
        List<DycActFscOrderInfo> dycActFscOrderInfos = dycActFscOrderModel.queryFscOrderList(dycActFscOrderQryDo);
        DycActQueryFscOrderListRspBO rspBo = new DycActQueryFscOrderListRspBO();
        List<DycActFscOrderInfoBO> jsl = ActRu.jsl(dycActFscOrderInfos, DycActFscOrderInfoBO.class);
        rspBo.setDycActFscOrderInfoBos(jsl);
        rspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBo;
    }
}
