package com.tydic.dyc.act.service.impl;

import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.DycActFscInvoiceModel;
import com.tydic.dyc.act.model.api.DycActFscOrderModel;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.service.api.DycActQueryFscOrderPageListService;
import com.tydic.dyc.act.service.bo.DycActActiveFileInfoBO;
import com.tydic.dyc.act.service.bo.DycActFscOrderInfoBO;
import com.tydic.dyc.act.service.bo.DycActQueryFscOrderPageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryFscOrderPageListRspBO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.utils.JUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @ClassName DycActQueryFscOrderPageListServiceImpl
 * @Author 14051
 * @Date 2024/4/3 16:07
 * @Version 1.0
 * @Description TODO
 **/
@HTServiceImpl
public class DycActQueryFscOrderPageListServiceImpl implements DycActQueryFscOrderPageListService {

    @Autowired
    private DycActFscOrderModel dycActFscOrderModel;
    @Autowired
    private DycActFscInvoiceModel dycActFscInvoiceModel;

    @Override
    public DycActQueryFscOrderPageListRspBO queryFscOrderPageList(DycActQueryFscOrderPageListReqBO reqBO) {
        DycActQueryFscOrderPageListRspBO rspBO = new DycActQueryFscOrderPageListRspBO();
        DycActFscOrderQryDO dycActFscOrderQryDO = new DycActFscOrderQryDO();
        BeanUtils.copyProperties(reqBO, dycActFscOrderQryDO);
        //运营查所有，工会管理员查自己公司
        if ("0".equals(reqBO.getIsProfessionalOrgExt())){
            dycActFscOrderQryDO.setCreateCompanyId(null);
        } else {
            dycActFscOrderQryDO.setCreateCompanyId(reqBO.getCompanyId());
        }
        if (StringUtils.isNotBlank(reqBO.getFscOrderNo())){
            dycActFscOrderQryDO.setOrderNo(reqBO.getFscOrderNo());
        }
        BasePageRspBo<DycActFscOrderInfo> dycActFscOrderInfoBasePageRspBo = dycActFscOrderModel.selectByCondition(dycActFscOrderQryDO);
        if (dycActFscOrderInfoBasePageRspBo != null){
            rspBO.setPageNo(dycActFscOrderInfoBasePageRspBo.getPageNo());
            rspBO.setRecordsTotal(dycActFscOrderInfoBasePageRspBo.getRecordsTotal());
            rspBO.setTotal(dycActFscOrderInfoBasePageRspBo.getTotal());
            if (!CollectionUtils.isEmpty(dycActFscOrderInfoBasePageRspBo.getRows())) {
                List<Long> fscOrderIds = dycActFscOrderInfoBasePageRspBo.getRows().stream().map(DycActFscOrderInfo::getFscOrderId).collect(Collectors.toList());
                //批量查询附件
                //发票附件
                Map<Long, List<DycActFscOrderFileInfo>> fileMap = new HashMap<>();
                //对账单附件
                Map<Long, List<DycActFscOrderFileInfo>> billFileMap = new HashMap<>();
                DycActFscOrderFileQryDO dycActFscOrderFileQryDO = new DycActFscOrderFileQryDO();
                dycActFscOrderFileQryDO.setFscOrderIds(fscOrderIds);
                List<DycActFscOrderFileInfo> dycActFscOrderFileInfos = dycActFscOrderModel.selectFileListByIds(dycActFscOrderFileQryDO);
                if (!CollectionUtils.isEmpty(dycActFscOrderFileInfos)){
                    fileMap = dycActFscOrderFileInfos.stream().filter(item -> item.getFileType().equals(DycActivityConstants.FILE_TYPE.FILE_TYPE_INVOICE)).collect(Collectors.groupingBy(DycActFscOrderFileInfo::getObjId));
                    billFileMap = dycActFscOrderFileInfos.stream().filter(item -> item.getFileType().equals(DycActivityConstants.FILE_TYPE.FILE_TYPE_BILL)).collect(Collectors.groupingBy(DycActFscOrderFileInfo::getObjId));
                }

                //批量查询发票金额
                Map<Long, BigDecimal> invoiceAmtMap = new HashMap<>();
                DycActFscInvoiceAmtDO dycActFscInvoiceAmtDO = new DycActFscInvoiceAmtDO();
                dycActFscInvoiceAmtDO.setFscOrderIds(fscOrderIds);
                List<DycActFscInvoiceAmt> dycActFscInvoiceAmts = dycActFscInvoiceModel.getInvoiceAmtByFscOrderIds(dycActFscInvoiceAmtDO);
                if (!CollectionUtils.isEmpty(dycActFscInvoiceAmts)){
                    invoiceAmtMap = dycActFscInvoiceAmts.stream().collect(Collectors.toMap(DycActFscInvoiceAmt::getFscOrderId, DycActFscInvoiceAmt::getInvoiceAmt));
                }
                Map<Long, List<DycActFscOrderFileInfo>> finalFileMap = fileMap;
                Map<Long, List<DycActFscOrderFileInfo>> finalBillFileMap = billFileMap;
                Map<Long, BigDecimal> finalInvoiceAmtMap = invoiceAmtMap;
                List<DycActFscOrderInfoBO> dycActOrderInfoBOList = dycActFscOrderInfoBasePageRspBo.getRows().stream().map(bo -> {
                    DycActFscOrderInfoBO dycActOrderInfoBO = new DycActFscOrderInfoBO();
                    BeanUtils.copyProperties(bo, dycActOrderInfoBO);
                    //拼接邮寄详情
                    if (StringUtils.isNotBlank(bo.getLogisticsOrder())) {
                        dycActOrderInfoBO.setMailDesc("快递公司：" + bo.getLogisticsCompany() + "  " + "快递单号：" + bo.getLogisticsOrder());
                    }

                    if (finalInvoiceAmtMap.containsKey(bo.getFscOrderId())){
                        dycActOrderInfoBO.setInvoiceCharge(finalInvoiceAmtMap.get(bo.getFscOrderId()));
                    }
                    if (finalFileMap.containsKey(bo.getFscOrderId())){
                        dycActOrderInfoBO.setAttachmentList(JUtil.jsl(finalFileMap.get(bo.getFscOrderId()), DycActActiveFileInfoBO.class));
                    }
                    if (finalBillFileMap.containsKey(bo.getFscOrderId())){
                        dycActOrderInfoBO.setBillAttList(JUtil.jsl(finalBillFileMap.get(bo.getFscOrderId()), DycActActiveFileInfoBO.class));
                    }
                    return dycActOrderInfoBO;
                }).collect(Collectors.toList());
                rspBO.setRows(dycActOrderInfoBOList);
            }
        }
        return rspBO;
    }
}
