package com.tydic.dyc.act.service.impl;

import com.tydic.dyc.act.model.api.DycActFscOrderModel;
import com.tydic.dyc.act.model.bo.DycActFscRelOrderDO;
import com.tydic.dyc.act.model.bo.DycActFscRelOrderInfo;
import com.tydic.dyc.act.service.api.DycActQueryFscRelOrderPageListService;
import com.tydic.dyc.act.service.bo.DycActFscRelOrderInfoBO;
import com.tydic.dyc.act.service.bo.DycActQueryFscRelOrderPageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryFscRelOrderPageListRspBO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.utils.JUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

/**
 * @ClassName DycActQueryFscRelOrderPageListServiceImpl
 * @Author 14051
 * @Date 2024/4/4 14:20
 * @Version 1.0
 **/
@HTServiceImpl
public class DycActQueryFscRelOrderPageListServiceImpl implements DycActQueryFscRelOrderPageListService {

    @Autowired
    private DycActFscOrderModel dycActFscOrderModel;

    @Override
    public DycActQueryFscRelOrderPageListRspBO queryFscRelOrderPageList(DycActQueryFscRelOrderPageListReqBO reqBO) {
        DycActQueryFscRelOrderPageListRspBO rspBO = new DycActQueryFscRelOrderPageListRspBO();

        DycActFscRelOrderDO dycActFscRelOrderDO = new DycActFscRelOrderDO();
        BeanUtils.copyProperties(reqBO, dycActFscRelOrderDO);
        dycActFscRelOrderDO.setStatus(reqBO.getCheckResult());
        BasePageRspBo<DycActFscRelOrderInfo> dycActFscRelOrderInfoBasePageRspBo = dycActFscOrderModel.selectRelOrderByConditon(dycActFscRelOrderDO);
        if (dycActFscRelOrderInfoBasePageRspBo != null) {
            rspBO.setPageNo(dycActFscRelOrderInfoBasePageRspBo.getPageNo());
            rspBO.setRecordsTotal(dycActFscRelOrderInfoBasePageRspBo.getRecordsTotal());
            rspBO.setTotal(dycActFscRelOrderInfoBasePageRspBo.getTotal());
            if (!CollectionUtils.isEmpty(dycActFscRelOrderInfoBasePageRspBo.getRows())) {
                rspBO.setRows(JUtil.jsl(dycActFscRelOrderInfoBasePageRspBo.getRows(), DycActFscRelOrderInfoBO.class));
            }
        }
        return rspBO;
    }
}
