package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActIaborModel;
import com.tydic.dyc.act.model.bo.DycActIaborDO;
import com.tydic.dyc.act.service.api.DycActQueryLaborUnionDetailsService;
import com.tydic.dyc.act.service.bo.DycActQueryLaborUnionDetailsReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryLaborUnionDetailsRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActQueryLaborUnionDetailsServiceImpl
 * 说明：
 * 时间： 2024-03-27 16:32
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActQueryLaborUnionDetailsServiceImpl implements DycActQueryLaborUnionDetailsService {

    @Autowired
    private DycActIaborModel dycActIaborModel;

    @Override
    public DycActQueryLaborUnionDetailsRspBO queryLaborUnionDetails(DycActQueryLaborUnionDetailsReqBO reqBO) {
        DycActIaborDO dycActivityDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActIaborDO.class);
        DycActQueryLaborUnionDetailsRspBO rspBO = JSON.parseObject(JSON.toJSONString(dycActIaborModel.queryLaborUnionDetails(dycActivityDO)), DycActQueryLaborUnionDetailsRspBO.class);
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
