package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActIaborModel;
import com.tydic.dyc.act.model.bo.DycActIaborDO;
import com.tydic.dyc.act.service.api.DycActQueryLaborUnionPageListService;
import com.tydic.dyc.act.service.bo.DycActQueryLaborUnionPageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryLaborUnionPageListRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActQueryLaborUnionPageListServiceImpl
 * 说明：
 * 时间： 2024-03-27 14:52
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActQueryLaborUnionPageListServiceImpl implements DycActQueryLaborUnionPageListService {

    @Autowired
    private DycActIaborModel dycActIaborModel;

    @Override
    public DycActQueryLaborUnionPageListRspBO queryLaborUnionPageList(DycActQueryLaborUnionPageListReqBO reqBO) {

        DycActIaborDO dycActivityDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActIaborDO.class);
        DycActQueryLaborUnionPageListRspBO rspBO = JSON.parseObject(JSON.toJSONString(dycActIaborModel.queryLaborUnionPageList(dycActivityDO)), DycActQueryLaborUnionPageListRspBO.class);
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
