package com.tydic.dyc.act.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActOrderModel;
import com.tydic.dyc.act.model.bo.ActOrderConsigneeInfoBO;
import com.tydic.dyc.act.model.bo.ActOrderItemInfoDO;
import com.tydic.dyc.act.model.bo.DycActOrderInfo;
import com.tydic.dyc.act.model.bo.DycActOrderQryDO;
import com.tydic.dyc.act.service.api.DycActQueryOrderDetailService;
import com.tydic.dyc.act.service.bo.DycActOrderConsigneeBO;
import com.tydic.dyc.act.service.bo.DycActOrderItemBO;
import com.tydic.dyc.act.service.bo.DycActQueryOrderDetailReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryOrderDetailRspBO;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 类名： DycActQueryOrderDetailServiceImpl
 * 说明：
 *
 * @author： lishiqing
 * 时间： 2024/4/25 11:30
 */
@HTServiceImpl
public class DycActQueryOrderDetailServiceImpl implements DycActQueryOrderDetailService {

    @Autowired
    private DycActOrderModel dycActOrderModel;

    @Override
    public DycActQueryOrderDetailRspBO queryOrderDetail(DycActQueryOrderDetailReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR,"查询订单详情入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getOrderId())) {
            throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR,"查询订单详情入参订单ID[orderId]为空");
        }
        DycActQueryOrderDetailRspBO rspBO = ActRu.success(DycActQueryOrderDetailRspBO.class);
        DycActOrderQryDO qryDO = new DycActOrderQryDO();
        qryDO.setOrderId(reqBO.getOrderId());
        DycActOrderInfo orderInfo = dycActOrderModel.queryOrderDetail(qryDO);
        if (ObjectUtil.isEmpty(orderInfo)) {
            rspBO.setRespDesc(DycActivityRspConstants.RESP_CODE_ERROR);
            rspBO.setRespDesc("查询订单详情失败");
            return rspBO;
        }
        rspBO = ActRu.js(orderInfo,DycActQueryOrderDetailRspBO.class);
        List<ActOrderItemInfoDO> orderItemInfoDOS = dycActOrderModel.qryOrderItemInfoList(qryDO);
        if (ObjectUtil.isNotEmpty(orderItemInfoDOS)) {
            rspBO.setActOrderItemBOList(ActRu.jsl(orderItemInfoDOS, DycActOrderItemBO.class));
        }
        // 查询订单收件人
        ActOrderConsigneeInfoBO orderConsigneeInfoBO =dycActOrderModel.qryOrderConsignee(qryDO);
        if (ObjectUtil.isNotEmpty(orderConsigneeInfoBO)) {
            rspBO.setActOrderConsigneeBO(ActRu.js(orderConsigneeInfoBO, DycActOrderConsigneeBO.class));
        }
        return rspBO;
    }
}
