package com.tydic.dyc.act.service.impl;

import com.tydic.dyc.act.model.api.DycActOrderModel;
import com.tydic.dyc.act.model.bo.DycActOrderInfo;
import com.tydic.dyc.act.model.bo.DycActOrderQryDO;
import com.tydic.dyc.act.service.api.DycActQueryOrderPageListService;
import com.tydic.dyc.act.service.bo.DycActOrderInfoBO;
import com.tydic.dyc.act.service.bo.DycActOrderItemBO;
import com.tydic.dyc.act.service.bo.DycActQueryOrderPageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryOrderPageListRspBO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @ClassName DycActQueryOrderPageListServiceImpl
 * @Author 14051
 * @Date 2024/4/2 10:42
 * @Version 1.0
 * @Description 福利订单列表查询（分页）实现类
 **/
@HTServiceImpl
public class DycActQueryOrderPageListServiceImpl implements DycActQueryOrderPageListService {

    @Autowired
    private DycActOrderModel dycActOrderModel;

    @Override
    public DycActQueryOrderPageListRspBO queryOrderPageList(DycActQueryOrderPageListReqBO reqBO) {
        DycActQueryOrderPageListRspBO rspBO = new DycActQueryOrderPageListRspBO();
        DycActOrderQryDO dycActOrderQryDO = new DycActOrderQryDO();
        BeanUtils.copyProperties(reqBO, dycActOrderQryDO);
        BasePageRspBo<DycActOrderInfo> dycActOrderInfoBasePageRspBo = dycActOrderModel.qryOrdInfoPageList(dycActOrderQryDO);
        if (dycActOrderInfoBasePageRspBo != null) {
            rspBO.setPageNo(dycActOrderInfoBasePageRspBo.getPageNo());
            rspBO.setRecordsTotal(dycActOrderInfoBasePageRspBo.getRecordsTotal());
            rspBO.setTotal(dycActOrderInfoBasePageRspBo.getTotal());
            if (!CollectionUtils.isEmpty(dycActOrderInfoBasePageRspBo.getRows())) {
                List<DycActOrderInfoBO> dycActOrderInfoBOList = new ArrayList<>();
                dycActOrderInfoBasePageRspBo.getRows().forEach(bo -> {
                    DycActOrderInfoBO dycActOrderInfoBO = new DycActOrderInfoBO();
                    BeanUtils.copyProperties(bo, dycActOrderInfoBO);
                    if (StringUtils.isNotBlank(bo.getSkuId())) {
                        List<DycActOrderItemBO> itemBOS = new ArrayList<>(1);
                        DycActOrderItemBO dycActOrderItemBO = new DycActOrderItemBO();
                        dycActOrderItemBO.setSkuCode(bo.getSkuCode());
                        dycActOrderItemBO.setSkuId(bo.getSkuId());
                        dycActOrderItemBO.setSkuName(bo.getSkuName());
                        dycActOrderItemBO.setSkuPicUrl(bo.getSkuPicUrl());
                        itemBOS.add(dycActOrderItemBO);
                        dycActOrderInfoBO.setOrderItemInfo(itemBOS);
                    }
                    dycActOrderInfoBOList.add(dycActOrderInfoBO);
                });
                rspBO.setRows(dycActOrderInfoBOList);
            }
        }
        //查询当前活动下的订单中积分支付总数
        BigDecimal totalScore = dycActOrderModel.getTotalScoreByActivityId(reqBO.getActivityId());
        if (totalScore == null){
            totalScore = BigDecimal.ZERO;
        }
        rspBO.setTotalScore(totalScore);
        return rspBO;
    }
}
