package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActIaborModel;
import com.tydic.dyc.act.model.bo.DycActIaborDO;
import com.tydic.dyc.act.model.bo.DycActLaborUnionInfo;
import com.tydic.dyc.act.service.api.DycActQueryOrgBelongLaborUnionService;
import com.tydic.dyc.act.service.bo.DycActLaborUnionInfoBO;
import com.tydic.dyc.act.service.bo.DycActQueryOrgBelongLaborUnionReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryOrgBelongLaborUnionRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * 标题：DycActQueryOrgBelongLaborUnionServiceImpl
 * 说明：
 * 时间： 2024-04-01 15:07
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActQueryOrgBelongLaborUnionServiceImpl implements DycActQueryOrgBelongLaborUnionService {

    @Autowired
    private DycActIaborModel dycActIaborModel;

    @Override
    public DycActQueryOrgBelongLaborUnionRspBO queryOrgBelongLaborUnion(DycActQueryOrgBelongLaborUnionReqBO reqBO) {

        DycActIaborDO dycActivityDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActIaborDO.class);
        List<DycActLaborUnionInfo> laborUnionInfos = dycActIaborModel.queryOrgBelongLaborUnion(dycActivityDO);
        List<DycActLaborUnionInfoBO> infoBOS = JSON.parseArray(JSON.toJSONString(laborUnionInfos), DycActLaborUnionInfoBO.class);
        DycActQueryOrgBelongLaborUnionRspBO rspBO = new DycActQueryOrgBelongLaborUnionRspBO();
        rspBO.setRows(infoBOS);
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }

}
