package com.tydic.dyc.act.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActSkuInfoModel;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.service.api.DycActQuerySkuDetailsService;
import com.tydic.dyc.act.service.bo.DycActQuerySkuDetailsReqBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuDetailsRspBO;
import com.tydic.dyc.act.service.bo.DycActSkuParamsBO;
import com.tydic.dyc.act.service.bo.DycActSkuPicBO;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 类名： DycActQuerySkuDetailsServiceImpl
 * 说明：商品详情查询服务实现
 *
 * @author： lishiqing
 * 时间： 2024/4/11 18:10
 */
@HTServiceImpl
public class DycActQuerySkuDetailsServiceImpl implements DycActQuerySkuDetailsService {

    @Autowired
    private DycActSkuInfoModel dycActSkuInfoModel;

    @Override
    public DycActQuerySkuDetailsRspBO querySkuDetails(DycActQuerySkuDetailsReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR,"商品详情查询入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR,"商品详情查询入参单品ID[skuId]为空");
        }
        DycActQuerySkuDetailsRspBO rspBO = ActRu.success(DycActQuerySkuDetailsRspBO.class);
        ActSkuInfoReqBO qryBO = new ActSkuInfoReqBO();
        qryBO.setSkuId(reqBO.getSkuId());
        ActSkuInfoRspBO skuInfoRspBO =dycActSkuInfoModel.querySkuDetails(qryBO);
        if (ObjectUtil.isEmpty(skuInfoRspBO.getData())) {
            rspBO.setRespDesc("查询结果为空");
            return rspBO;
        }

         rspBO = ActRu.js(skuInfoRspBO.getData(), DycActQuerySkuDetailsRspBO.class);

        // 单品状态翻译
        if (DycActivityConstants.SkuStatue.ON_SALE.equals(rspBO.getSkuStatus())) {
            rspBO.setSkuStatusDesc(DycActivityConstants.SkuStatue.ON_SALE_STR);
        } else if (DycActivityConstants.SkuStatue.WITHDRAWN.equals(rspBO.getSkuStatus())) {
            rspBO.setSkuStatusDesc(DycActivityConstants.SkuStatue.WITHDRAWN_STR);
        } else if (DycActivityConstants.SkuStatue.DELETE.equals(rspBO.getSkuStatus())) {
            rspBO.setSkuStatusDesc(DycActivityConstants.SkuStatue.DELETE_STR);
        }

        // 商品图片查询
        ActSkuPicReqBO skuPicReqBO = new ActSkuPicReqBO();
        skuPicReqBO.setSkuId(reqBO.getSkuId());
        List<ActSkuPicBO> skuPicBOList = dycActSkuInfoModel.queryActSkuPicList(skuPicReqBO).getData();
        if (CollectionUtil.isNotEmpty(skuPicBOList)) {
            List<DycActSkuPicBO> skuPicList = skuPicBOList.stream().map(picBO -> {
                DycActSkuPicBO skuPicBO = new DycActSkuPicBO();
                skuPicBO.setPicType(picBO.getPicType());
                skuPicBO.setPicUrl(picBO.getSkuPicUrl());
                skuPicBO.setPicOrder(picBO.getPicOrder());
                return skuPicBO;
            }).collect(Collectors.toList());
            rspBO.setSkuPicList(skuPicList);
        }

        // 商品属性查询
        ActSkuSpecReqBO specReqBO = new ActSkuSpecReqBO();
        specReqBO.setSkuId(reqBO.getSkuId());
        List<ActSkuSpecBO> skuSpecBOList = dycActSkuInfoModel.queryActSkuSpecList(specReqBO).getData();
        if (CollectionUtil.isNotEmpty(skuSpecBOList)) {
            List<DycActSkuParamsBO> skuParamList = skuSpecBOList.stream().map(specBO -> {
                DycActSkuParamsBO paramsBO = new DycActSkuParamsBO();
                paramsBO.setPropName(specBO.getPropName());
                paramsBO.setPropValue(specBO.getPropValue());
                return paramsBO;
            }).collect(Collectors.toList());
            rspBO.setSkuParamList(skuParamList);
        }

        return rspBO;
    }
}
