package com.tydic.dyc.act.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.api.DycActSkuInfoModel;
import com.tydic.dyc.act.model.api.DycActSkuPoolModel;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.service.api.DycActQuerySkuPageListService;
import com.tydic.dyc.act.service.bo.*;
import com.tydic.dyc.act.utils.ActRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 类名： DycActQuerySkuPageListServiceImpl
 * 说明：商品列表查询（分页）服务实现
 *
 * @author： lishiqing
 * 时间： 2024/4/8 17:05
 */
@HTServiceImpl
public class DycActQuerySkuPageListServiceImpl implements DycActQuerySkuPageListService {

    @Autowired
    private DycActSkuInfoModel dycActSkuInfoModel;

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Autowired
    private DycActSkuPoolModel dycActSkuPoolModel;

    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;

    @Override
    public DycActQuerySkuPageListRspBO querySkuPageList(DycActQuerySkuPageListReqBO reqBO) {
        DycActQuerySkuPageListRspBO rspBO = ActRu.success(DycActQuerySkuPageListRspBO.class);
        ActSkuInfoQryBO qryBO = ActRu.js(reqBO, ActSkuInfoQryBO.class);

        if (ObjectUtil.isNotEmpty(reqBO.getGuideCatalogId()) && ObjectUtil.isEmpty(reqBO.getCatalogLevel())) {
            throw new ZTBusinessException("商品类目ID和商品类目等级必须一起传");
        }
        if (DycActivityConstants.CatalogLevel.THREE.equals(reqBO.getCatalogLevel())) {
            qryBO.setGuideId(reqBO.getGuideCatalogId());
        } else if (DycActivityConstants.CatalogLevel.TWO.equals(reqBO.getCatalogLevel())) {
            qryBO.setGuideIdList(qryGuideIdList(reqBO.getGuideCatalogId()));
        } else if (DycActivityConstants.CatalogLevel.ONE.equals(reqBO.getCatalogLevel())) {
            List<Long> threeGuideId = new ArrayList<>();
            List<Long> twoGuideId = qryGuideIdList(reqBO.getGuideCatalogId());
            if (!CollectionUtil.isEmpty(twoGuideId)) {
                for (Long guideId : twoGuideId) {
                    threeGuideId.addAll(qryGuideIdList(guideId));
                }

            }
            qryBO.setGuideIdList(threeGuideId);
        }

        // 如果排除活动ID不为空，查出活动关联商品
        if (ObjectUtil.isNotEmpty(reqBO.getExitsActivityId())) {
            DycActivityDO activityDO = new DycActivityDO();
            activityDO.setActivityId(reqBO.getExitsActivityId());
            activityDO.setCommodityRelaMethod(Integer.valueOf(DycActivityConstants.CommodityRelaMethod.COMMODITY_TYPE_THREE));
            List<DycActActivityRelaCommodityInfo> commodityInfoList = dycActActivityModel.queryActivityCommodityList(activityDO);
            if (!CollectionUtil.isEmpty(commodityInfoList)) {
                qryBO.setExitsSkuIds(commodityInfoList.stream().map(DycActActivityRelaCommodityInfo::getSkuId).collect(Collectors.toList()));
            }
        }
        if (ObjectUtil.isNotEmpty(reqBO.getExitsChangeId())) {
            ActActivityChangeCommodityInfoQryDO qryDO = new ActActivityChangeCommodityInfoQryDO();
            qryDO.setChangeId(reqBO.getExitsChangeId());
            List<ActivityChangeRelaCommodityInfo> commodityInfoList = dycActivityChangeModel.queryActivityChangeCommodityList(qryDO);
            if (!CollectionUtil.isEmpty(commodityInfoList)) {
                qryBO.setExitsSkuIds(commodityInfoList.stream().map(ActivityChangeRelaCommodityInfo::getSkuId).collect(Collectors.toList()));
            }
        }
        // 查询商品池下的商品ID
        if (ObjectUtil.isNotEmpty(reqBO.getPoolId())) {
            setPoolRelReqQuery(reqBO.getPoolId(), qryBO,DycActivityConstants.RelPoolOperType.REL);
        }
        if (ObjectUtil.isNotEmpty(reqBO.getExitsPoolId())) {
            setPoolRelReqQuery(reqBO.getPoolId(), qryBO,DycActivityConstants.RelPoolOperType.CANCEL_REL);
        }
        ActSkuInfoQryRspBO qryRspBO = dycActSkuInfoModel.querySkuPageList(qryBO);
        rspBO.setPageNo(qryRspBO.getPageNo());
        rspBO.setTotal(qryRspBO.getTotal());
        rspBO.setRecordsTotal(qryRspBO.getRecordsTotal());
        if (CollectionUtil.isEmpty(qryRspBO.getRows())) {
            rspBO.setRespDesc("查询结果为空");
            return rspBO;
        }
        ActSkuGuideReqBO guideReqBO = new ActSkuGuideReqBO();
        guideReqBO.setGuideCatalogIdList(qryRspBO.getRows().stream().map(ActSkuInfoDO::getGuideId).collect(Collectors.toList()));
        Map<Long, ActSkuGuideBO> fullNameByCatalogIdMap = dycActSkuInfoModel.getCatalogBOByCatalogIds(guideReqBO).getCatalogBOByCatalogIds();
        List<DycActQuerySkuPageListBO> rows = new ArrayList<>();
        for (ActSkuInfoDO skuInfoDO : qryRspBO.getRows()) {
            DycActQuerySkuPageListBO row = ActRu.js(skuInfoDO, DycActQuerySkuPageListBO.class);
            if (DycActivityConstants.SkuStatue.ON_SALE.equals(row.getSkuStatus())) {
                row.setSkuStatusDesc(DycActivityConstants.SkuStatue.ON_SALE_STR);
            } else if (DycActivityConstants.SkuStatue.WITHDRAWN.equals(row.getSkuStatus())) {
                row.setSkuStatusDesc(DycActivityConstants.SkuStatue.WITHDRAWN_STR);
            } else if (DycActivityConstants.SkuStatue.DELETE.equals(row.getSkuStatus())) {
                row.setSkuStatusDesc(DycActivityConstants.SkuStatue.DELETE_STR);
            }
            if (fullNameByCatalogIdMap.containsKey(skuInfoDO.getGuideId())) {
                ActSkuGuideBO actSkuGuideBO = fullNameByCatalogIdMap.get(skuInfoDO.getGuideId());
                row.setFirstCatalogId(actSkuGuideBO.getFirstCatalogId());
                row.setFirstCatalogName(actSkuGuideBO.getFirstCatalogName());
                row.setSecondCatalogId(actSkuGuideBO.getSecondCatalogId());
                row.setSecondCatalogName(actSkuGuideBO.getSecondCatalogName());
                row.setThreeCatalogId(actSkuGuideBO.getThreeCatalogId());
                row.setThreeCatalogName(actSkuGuideBO.getThreeCatalogName());
                row.setCatalogNameDesc(actSkuGuideBO.getCatalogFullName());
            }
            rows.add(row);
        }
        rspBO.setRows(rows);
        return rspBO;
    }

    private void setPoolRelReqQuery(Long poolId, ActSkuInfoQryBO qryBO,Integer relType) {
        DycActQuerySkuPoolReqBO skuPoolReqBO = new DycActQuerySkuPoolReqBO();
        skuPoolReqBO.setPoolId(poolId);
        DycActQuerySkuPoolRspBO skuPoolRspBO = dycActSkuPoolModel.querySkuPoolDetail(skuPoolReqBO);
        if (ObjectUtil.isEmpty(skuPoolRspBO)) {
            throw new ZTBusinessException("商品池不存在");
        }

        // 商品池关联业务
        ActRelSourcePoolReqBO relSourcePoolReqBO = new ActRelSourcePoolReqBO();
        relSourcePoolReqBO.setPoolId(poolId);
        List<ActRelSourcePoolBO> relSourcePoolBOS = dycActSkuPoolModel.queryActRelSourcePoolList(relSourcePoolReqBO).getData();
        if (!CollectionUtil.isEmpty(relSourcePoolBOS)) {
            List<Long> sourceIds = relSourcePoolBOS.stream().map(ActRelSourcePoolBO::getSourceId).collect(Collectors.toList());
            if (DycActivityConstants.RelPoolOperType.REL.equals(relType)) {
                // 判断商品此类型
                if (DycActivityConstants.PoolType.SUPPLIER.equals(skuPoolRspBO.getPoolType())) {
                    qryBO.setPoolSupplierIdList(sourceIds);
                    qryBO.setPoolId(null);
                } else if (DycActivityConstants.PoolType.CATALOG.equals(skuPoolRspBO.getPoolType())) {
                    qryBO.setPoolGuideIdList(sourceIds);
                    qryBO.setPoolId(null);
                }
            } else {
                // 判断商品此类型
                if (DycActivityConstants.PoolType.SUPPLIER.equals(skuPoolRspBO.getPoolType())) {
                    qryBO.setExitsPoolSupplierIdList(sourceIds);
                    qryBO.setExitsPoolId(null);
                } else if (DycActivityConstants.PoolType.CATALOG.equals(skuPoolRspBO.getPoolType())) {
                    qryBO.setExitsPoolGuideIdList(sourceIds);
                    qryBO.setExitsPoolId(null);
                }
            }
        }
    }

    private List<Long> qryGuideIdList(Long guideCatalogId) {
        ActSkuGuideReqBO qrySubGuideBO = new ActSkuGuideReqBO();
        qrySubGuideBO.setUpperCatalogId(guideCatalogId);
        List<ActSkuGuideBO> list = dycActSkuInfoModel.queryActSkuGuideList(qrySubGuideBO).getData();
        if (!CollectionUtil.isEmpty(list)) {
            return list.stream().map(ActSkuGuideBO::getGuideCatalogId).collect(Collectors.toList());
        }
        return new ArrayList<>();
    }
}
