package com.tydic.dyc.act.service.impl;

import com.tydic.dyc.act.model.api.DycActSkuPoolModel;
import com.tydic.dyc.act.model.bo.ActSkuPoolBO;
import com.tydic.dyc.act.model.bo.ActSkuPoolReqBO;
import com.tydic.dyc.act.service.api.DycActQuerySkuPoolDropService;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPoolDropReqBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPoolDropRspBO;
import com.tydic.dyc.act.service.bo.DycActSkuPoolDropBO;
import com.tydic.dyc.act.utils.ActRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 类名： DycActQuerySkuPoolDropServiceImpl
 * 说明：福利商品商品池下拉查询服务实现
 *
 * @author： lishiqing
 * 时间： 2024/4/17 11:16
 */
@HTServiceImpl
public class DycActQuerySkuPoolDropServiceImpl implements DycActQuerySkuPoolDropService {

    @Autowired
    private DycActSkuPoolModel dycActSkuPoolModel;

    @Override
    public DycActQuerySkuPoolDropRspBO querySkuPoolDrop(DycActQuerySkuPoolDropReqBO reqBO) {
        DycActQuerySkuPoolDropRspBO rspBO = ActRu.success(DycActQuerySkuPoolDropRspBO.class);
        ActSkuPoolReqBO poolReqBO = ActRu.js(reqBO,ActSkuPoolReqBO.class);
        List<ActSkuPoolBO> data = dycActSkuPoolModel.queryActSkuPoolList(poolReqBO).getData();
        rspBO.setRows(ActRu.jsl(data, DycActSkuPoolDropBO.class));
        return rspBO;
    }
}
