package com.tydic.dyc.act.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.ohaotian.plugin.base.bo.RspPage;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.DycActSkuPoolModel;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.service.api.DycActQuerySkuPoolPageListService;
import com.tydic.dyc.act.service.bo.*;
import com.tydic.dyc.act.utils.ActRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 类名： DycActQuerySkuPoolPageListServiceImpl
 * 说明：
 *
 * @author： lishiqing
 * 时间： 2024/4/16 15:00
 */
@HTServiceImpl
public class DycActQuerySkuPoolPageListServiceImpl implements DycActQuerySkuPoolPageListService {

    @Autowired
    private DycActSkuPoolModel dycActSkuPoolModel;

    @Override
    public DycActQuerySkuPoolPageListRspBO querySkuPoolPageList(DycActQuerySkuPoolPageListReqBO reqBO) {
        DycActQuerySkuPoolPageListRspBO rspBO = ActRu.success(DycActQuerySkuPoolPageListRspBO.class);
        ActSkuPoolReqBO skuPoolReqBO = ActRu.js(reqBO, ActSkuPoolReqBO.class);
        RspPage<ActSkuPoolBO> rspPage = dycActSkuPoolModel.querySkuPoolPageList(skuPoolReqBO);
        rspBO.setPageNo(rspPage.getPageNo());
        rspBO.setTotal(rspPage.getTotal());
        rspBO.setRecordsTotal(rspPage.getRecordsTotal());
        if (CollectionUtil.isEmpty(rspPage.getRows())) {
            rspBO.setRespDesc("查询结果为空");
            return rspBO;
        }
        List<DycActQuerySkuPoolPageListBO> rows = new ArrayList<>();
        for (ActSkuPoolBO skuPoolBO : rspPage.getRows()) {
            DycActQuerySkuPoolPageListBO row = ActRu.js(skuPoolBO, DycActQuerySkuPoolPageListBO.class);
            if (DycActivityConstants.PoolType.SUPPLIER.equals(row.getPoolType())) {
                row.setPoolTypeDesc(DycActivityConstants.PoolType.SUPPLIERSTR);
            } else if (DycActivityConstants.PoolType.COMMODITY.equals(row.getPoolType())) {
                row.setPoolTypeDesc(DycActivityConstants.PoolType.COMMODITYSTR);
            } else if (DycActivityConstants.PoolType.CATALOG.equals(row.getPoolType())) {
                row.setPoolTypeDesc(DycActivityConstants.PoolType.CATALOGSTR);
            }
            rows.add(row);
        }
        rspBO.setRows(rows);
        return rspBO;
    }
}
