package com.tydic.dyc.act.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.bo.RspPage;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActSkuInfoModel;
import com.tydic.dyc.act.model.api.DycActSkuPoolModel;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.service.api.DycActQuerySkuPoolRelPageListService;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPoolRelPageListBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPoolRelPageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPoolRelPageListRspBO;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 类名： DycActQuerySkuPoolRelPageListServiceImpl
 * 说明：
 *
 * @author： lishiqing
 * 时间： 2024/4/16 20:24
 */
@HTServiceImpl
public class DycActQuerySkuPoolRelPageListServiceImpl implements DycActQuerySkuPoolRelPageListService {

    @Autowired
    private DycActSkuPoolModel dycActSkuPoolModel;
    @Autowired
    private DycActSkuInfoModel dycActSkuInfoModel;

    @Override
    public DycActQuerySkuPoolRelPageListRspBO querySkuPoolRelPageList(DycActQuerySkuPoolRelPageListReqBO reqBO) {
        this.valData(reqBO);
        DycActQuerySkuPoolRelPageListRspBO rspBO = ActRu.success(DycActQuerySkuPoolRelPageListRspBO.class);
        // 供应商
        RspPage<ActRelSourcePoolBO> rspPage = new RspPage<>();
        if (DycActivityConstants.PoolType.SUPPLIER.equals(reqBO.getPoolType())) {
            ActRelSourcePoolReqBO sourcePoolReqBO = new ActRelSourcePoolReqBO();
            sourcePoolReqBO.setPageNo(reqBO.getPageNo());
            sourcePoolReqBO.setPageSize(reqBO.getPageSize());
            sourcePoolReqBO.setPoolId(reqBO.getPoolId());
            sourcePoolReqBO.setSourceId(reqBO.getVendorId());
            sourcePoolReqBO.setPoolType(reqBO.getPoolType());
            rspPage = dycActSkuPoolModel.querySkuPoolRelPageListBySup(sourcePoolReqBO);
        }
        if (DycActivityConstants.PoolType.CATALOG.equals(reqBO.getPoolType())) {
            ActRelSourcePoolReqBO sourcePoolReqBO = new ActRelSourcePoolReqBO();
            sourcePoolReqBO.setPoolId(reqBO.getPoolId());
            sourcePoolReqBO.setPoolType(reqBO.getPoolType());
            sourcePoolReqBO.setPageNo(reqBO.getPageNo());
            sourcePoolReqBO.setPageSize(reqBO.getPageSize());
            if (DycActivityConstants.CatalogLevel.THREE.equals(reqBO.getCatalogLevel())) {
                sourcePoolReqBO.setSourceId(reqBO.getGuideCatalogId());
            } else if (DycActivityConstants.CatalogLevel.TWO.equals(reqBO.getCatalogLevel())) {
                sourcePoolReqBO.setSourceIdList(qryGuideIdList(reqBO.getGuideCatalogId()));
            } else if (DycActivityConstants.CatalogLevel.ONE.equals(reqBO.getCatalogLevel())) {
                List<Long> threeGuideId = new ArrayList<>();
                List<Long> twoGuideId = qryGuideIdList(reqBO.getGuideCatalogId());
                if (!CollectionUtil.isEmpty(twoGuideId)) {
                    for (Long guideId : twoGuideId) {
                        threeGuideId.addAll(qryGuideIdList(guideId));
                    }

                }
                sourcePoolReqBO.setSourceIdList(threeGuideId);
            }
            rspPage = dycActSkuPoolModel.querySkuPoolRelPageListByCatalog(sourcePoolReqBO);
        }
        rspBO.setPageNo(rspPage.getPageNo());
        rspBO.setTotal(rspPage.getTotal());
        rspBO.setRecordsTotal(rspPage.getRecordsTotal());
        if (CollectionUtil.isEmpty(rspPage.getRows())) {
            rspBO.setRespDesc("查询结果为空");
            return rspBO;
        }
        rspBO.setRows(ActRu.jsl(rspPage.getRows(), DycActQuerySkuPoolRelPageListBO.class));
        return rspBO;
    }

    private List<Long> qryGuideIdList(Long guideCatalogId) {
        ActSkuGuideReqBO qrySubGuideBO = new ActSkuGuideReqBO();
        qrySubGuideBO.setUpperCatalogId(guideCatalogId);
        List<ActSkuGuideBO> list = dycActSkuInfoModel.queryActSkuGuideList(qrySubGuideBO).getData();
        if (!CollectionUtil.isEmpty(list)) {
            return list.stream().map(ActSkuGuideBO::getGuideCatalogId).collect(Collectors.toList());
        }
        return new ArrayList<>();
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void valData(DycActQuerySkuPoolRelPageListReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR,"商品池已关联列表查询（分页）服务入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getPoolId())) {
            throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR,"商品池已关联列表查询（分页）服务入参商品池ID[poolId]为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getPoolType())) {
            throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR,"商品池已关联列表查询（分页）服务入参商品池关联类型[poolType]为空");
        }
        if (ObjectUtil.isNotEmpty(reqBO.getGuideCatalogId()) && ObjectUtil.isEmpty(reqBO.getCatalogLevel())) {
            throw new BaseBusinessException(DycActivityRspConstants.RESP_CODE_ERROR,"类目ID和类目等级必须一起传");
        }
    }
}
