package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.model.bo.DycActivityUserInfo;
import com.tydic.dyc.act.service.api.DycActQueryUserNotInPoolListService;
import com.tydic.dyc.act.service.bo.DycActActivityUserInfoBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivityUserPageListReqBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题：DycActQueryUserNotInPoolListServiceImpl
 * 说明：
 * 时间： 2024-04-15 17:29
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActQueryUserNotInPoolListServiceImpl implements DycActQueryUserNotInPoolListService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public List<DycActActivityUserInfoBO> queryActivityUserNotInPoolList(DycActQueryActivityUserPageListReqBO reqBO) {
        DycActivityDO dycActivityDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityDO.class);
        List<DycActivityUserInfo> userInfos = dycActActivityModel.queryActivityUserNotInPoolList(dycActivityDO);
        List<DycActActivityUserInfoBO> userInfoBOS = JSON.parseArray(JSON.toJSONString(userInfos), DycActActivityUserInfoBO.class);
        return userInfoBOS;
    }
}
