package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.ActSysDictionaryModel;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActUserScoresBaseInfo;
import com.tydic.dyc.act.model.bo.DycActUserScoresBaseInfoQueryBO;
import com.tydic.dyc.act.service.api.DycActQueryUserScoresPageListService;
import com.tydic.dyc.act.service.bo.DycActQueryUserScoresPageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryUserScoresPageListRspBO;
import com.tydic.dyc.act.service.bo.DycActUserScoresBaseInfoBO;
import com.tydic.dyc.act.utils.ActRu;
import com.tydic.dyc.base.bo.BasePageRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 标题 DycActQueryUserScoresPageListServiceImpl
 * 说明 用户积分信息查询
 * 时间 2024/4/16 14:41
 *
 * @author 唐富强
 */
@HTServiceImpl
public class DycActQueryUserScoresPageListServiceImpl implements DycActQueryUserScoresPageListService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Autowired
    private ActSysDictionaryModel actSysDictionaryModel;

    @Override
    public DycActQueryUserScoresPageListRspBO queryUserScoresPageList(DycActQueryUserScoresPageListReqBO reqBO) {

        DycActUserScoresBaseInfoQueryBO dycActUserScoresBaseInfoQueryBO = getQryBo(reqBO);
        BasePageRspBo<DycActUserScoresBaseInfo> dycActUserScoresBaseInfoBasePageRspBo = dycActActivityModel.queryUserScoresPageList(dycActUserScoresBaseInfoQueryBO);
        return translators(dycActUserScoresBaseInfoBasePageRspBo);
    }


    /**
     * 查询参数构建
     * @param reqBO
     * @return
     */
    private DycActUserScoresBaseInfoQueryBO getQryBo(DycActQueryUserScoresPageListReqBO reqBO) {
        DycActUserScoresBaseInfoQueryBO dycActUserScoresBaseInfoQueryBO = ActRu.js(reqBO, DycActUserScoresBaseInfoQueryBO.class);
        if(CollectionUtils.isEmpty(reqBO.getActivityStateList())){
            List<String> pCodes = new ArrayList<>(1);
            pCodes.add(DycActivityConstants.PCode.ACT_USER_SCORE_TAB);
            Map<String, Map<String, String>> map = actSysDictionaryModel.getDictionaryMap(pCodes);
            if(reqBO.getTabId() == null){
                reqBO.setTabId(DycActivityConstants.ActUserScoreTab.DEFAULT);
            }
            String stateListStr = getDic(DycActivityConstants.PCode.ACT_USER_SCORE_TAB,reqBO.getTabId().toString(),map);
            if(StringUtils.hasText(stateListStr)){
                dycActUserScoresBaseInfoQueryBO.setActivityStateList(JSONArray.parseArray(stateListStr,String.class));
            }
        }

        return dycActUserScoresBaseInfoQueryBO;
    }

    /**
     * 字段翻译
     *
     * @param pageRspBo
     */
    private DycActQueryUserScoresPageListRspBO translators(BasePageRspBo<DycActUserScoresBaseInfo> pageRspBo) {
        DycActQueryUserScoresPageListRspBO rspBO = ActRu.js(pageRspBo, DycActQueryUserScoresPageListRspBO.class);
        if (!CollectionUtils.isEmpty(rspBO.getRows())) {
            List<String> pCodes = new ArrayList<>(2);
            pCodes.add(DycActivityConstants.PCode.ACTIVITY_TYPE);
            pCodes.add(DycActivityConstants.PCode.ACTIVITY_STATE);
            Map<String, Map<String, String>> map = actSysDictionaryModel.getDictionaryMap(pCodes);
            for (DycActUserScoresBaseInfoBO infoBO : rspBO.getRows()) {
                infoBO.setActivityStateStr(getDic(DycActivityConstants.PCode.ACTIVITY_STATE, infoBO.getActivityState(), map));
                infoBO.setActivityTypeStr(getDic(DycActivityConstants.PCode.ACTIVITY_TYPE, infoBO.getActivityType().toString(), map));
            }
        }
        return rspBO;
    }

    /**
     * 翻译获取
     *
     * @param pCode
     * @param code
     * @param map
     * @return
     */
    private String getDic(String pCode, String code, Map<String, Map<String, String>> map) {
        if (!CollectionUtils.isEmpty(map)) {
            if (map.containsKey(pCode)) {
                return map.get(pCode).get(code);
            } else {
                return null;
            }
        } else {
            return null;
        }
    }
}
