package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActQuoteActivityCommodityService;
import com.tydic.dyc.act.service.bo.DycActQuoteActivityCommodityReqBO;
import com.tydic.dyc.act.service.bo.DycActQuoteActivityCommodityRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;

/**
 * 标题：DycActQuoteActivityCommodityServiceImpl
 * 说明：
 * 时间： 2024-04-02 14:20
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActQuoteActivityCommodityServiceImpl implements DycActQuoteActivityCommodityService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActQuoteActivityCommodityRspBO quoteActivityCommodity(DycActQuoteActivityCommodityReqBO reqBO) {
        checkParam(reqBO);
        DycActivityDO dycActivityDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityDO.class);
        dycActivityDO.setCreateUserId(reqBO.getUserId());
        dycActivityDO.setCreateUserName(reqBO.getName());
        dycActActivityModel.quoteActivityCommodity(dycActivityDO);
        DycActQuoteActivityCommodityRspBO rspBO = new DycActQuoteActivityCommodityRspBO();
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }

    public void checkParam(DycActQuoteActivityCommodityReqBO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("参数为空！");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("活动id为空！");
        }
        if (null == reqBO.getQuoteActivityId()) {
            throw new ZTBusinessException("引用活动id为空！");
        }
    }
}
