package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActScoresNotUsedService;
import com.tydic.dyc.act.service.bo.DycActScoresNotUsedReqBO;
import com.tydic.dyc.act.service.bo.DycActScoresNotUsedRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActScoresNotUsedServiceImpl
 * 说明：
 * 时间： 2024-04-24 19:04
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActScoresNotUsedServiceImpl implements DycActScoresNotUsedService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActScoresNotUsedRspBO scoresNotUsed(DycActScoresNotUsedReqBO reqBO) {

        DycActivityDO recordDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityDO.class);
        int i = dycActActivityModel.selectNotUsedScores(recordDO);
        DycActScoresNotUsedRspBO rspBO = new DycActScoresNotUsedRspBO();
        if (i > 0) {
            rspBO.setFlag(true);
        }
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
