package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.DycActSubmitActivityChangeReqDO;
import com.tydic.dyc.act.model.bo.DycActSubmitActivityChangeRspDO;
import com.tydic.dyc.act.service.api.DycActSubmitChangeActivityService;
import com.tydic.dyc.act.service.bo.DycActSubmitActivityChangeReqBO;
import com.tydic.dyc.act.service.bo.DycActSubmitActivityChangeRspBO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActSubmitChangeActivityServiceImpl
 * 说明：用于活动变更提交API实现类
 * 时间：2024/4/16 11:37 上午
 * 作者：汪成松
 */
@HTServiceImpl
public class DycActSubmitChangeActivityServiceImpl implements DycActSubmitChangeActivityService {

    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;

    @Override
    public DycActSubmitActivityChangeRspBO submitActivityChange(DycActSubmitActivityChangeReqBO reqBo) {
        DycActSubmitActivityChangeReqDO dycActSubmitActivityChangeReqDo = JSONObject.parseObject(JSONObject.toJSONString(reqBo), DycActSubmitActivityChangeReqDO.class);
        DycActSubmitActivityChangeRspDO dycActSubmitActivityChangeRspDo = dycActivityChangeModel.submitActivityChange(dycActSubmitActivityChangeReqDo);
        if (!BaseRspConstant.RSP_CODE_SUCCESS.equals(dycActSubmitActivityChangeRspDo.getRespCode())){
            throw new BaseBusinessException(dycActSubmitActivityChangeRspDo.getRespCode(),dycActSubmitActivityChangeRspDo.getRespDesc());
        }
        return JSONObject.parseObject(JSONObject.toJSONString(dycActSubmitActivityChangeRspDo),DycActSubmitActivityChangeRspBO.class);
    }
}
