package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActProcessModel;
import com.tydic.dyc.act.model.bo.DycProcessDO;
import com.tydic.dyc.act.service.api.DycActTaskDealFinishService;
import com.tydic.dyc.act.service.bo.DycActTaskDealActivityReqBO;
import com.tydic.dyc.act.service.bo.DycActTaskDealActivityRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActTaskDealFinishServiceImpl
 * 说明：
 * 时间： 2024-04-09 11:15
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActTaskDealFinishServiceImpl implements DycActTaskDealFinishService {

    @Autowired
    private DycActProcessModel dycActProcessModel;

    @Override
    public DycActTaskDealActivityRspBO dealTaskFinish(DycActTaskDealActivityReqBO reqBO) {
        DycProcessDO processDO = JSON.parseObject(JSON.toJSONString(reqBO), DycProcessDO.class);
        dycActProcessModel.dealTaskFinish(processDO);
        DycActTaskDealActivityRspBO rspBO = new DycActTaskDealActivityRspBO();
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
