package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActProcessModel;
import com.tydic.dyc.act.model.bo.DycProcessDO;
import com.tydic.dyc.act.service.api.DycActTaskDealService;
import com.tydic.dyc.act.service.bo.DycActTaskDealActivityReqBO;
import com.tydic.dyc.act.service.bo.DycActTaskDealActivityRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActTaskDealServiceImpl
 * 说明：审批相关操作
 * 时间： 2023-12-28 15:39
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActTaskDealServiceImpl implements DycActTaskDealService {

    @Autowired
    private DycActProcessModel dycActProcessModel;

    @Override
    public DycActTaskDealActivityRspBO dealTaskDeal(DycActTaskDealActivityReqBO reqBO) {
        DycProcessDO processDO = JSON.parseObject(JSON.toJSONString(reqBO), DycProcessDO.class);
        dycActProcessModel.dealTaskDeal(processDO);
        DycActTaskDealActivityRspBO rspBO = new DycActTaskDealActivityRspBO();
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
