package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.service.api.DycActUnifyTodoQryService;
import com.tydic.dyc.act.service.bo.ActUnifyTodoQryExtBO;
import com.tydic.dyc.act.service.bo.ActUnifyTodoQryReqBO;
import com.tydic.dyc.act.service.bo.ActUnifyTodoQryRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;


/**
 * 标题：DycActUnifyTodoQryServiceImpl
 * 说明：无
 * 时间：2024/4/15
 *
 * @author zhoujie
 */
@HTServiceImpl
public class DycActUnifyTodoQryServiceImpl implements DycActUnifyTodoQryService {
    @Autowired
    private DycActActivityModel dycActActivityModel;
    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;

    @Override
    public ActUnifyTodoQryRspBO qryTodoInfo(ActUnifyTodoQryReqBO reqBO) {
        //入参校验
        check(reqBO);
        ActUnifyTodoQryRspBO rspBO = new ActUnifyTodoQryRspBO();

        //业务类型待办
        Long objCreateUserId = 1L;
        ActUnifyTodoQryExtBO actUnifyTodoQryExtBo = new ActUnifyTodoQryExtBO();
        if(DycActivityConstants.TodoType.ACT_AUDIT.equals(reqBO.getObjType())){
            DycActivityDO dycActivityDO = new DycActivityDO();
            dycActivityDO.setActivityId(reqBO.getShareId());
            DycActivityBaseInfo dycActivityBaseInfo = dycActActivityModel.getActivityBaseInfoDetail(dycActivityDO);
            if(dycActivityBaseInfo == null){
                throw new ZTBusinessException("活动基本信息查询为空");
            }
            objCreateUserId = dycActivityBaseInfo.getCreateUserId();
            actUnifyTodoQryExtBo.setActivityCode(dycActivityBaseInfo.getActivityCode());
        }else if(DycActivityConstants.TodoType.ACT_AUDIT_CHANGE.equals(reqBO.getObjType())){
            DycActivityChangeDO dycActivityChangeDo = new DycActivityChangeDO();
            dycActivityChangeDo.setChangeId(reqBO.getShareId());
            DycActivityChangeRspDO dycActivityChangeRspDO = dycActivityChangeModel.queryActivityChangeBaseInfo(dycActivityChangeDo);
            DycActivityChangeInfo changeBaseDetail = dycActivityChangeRspDO.getChangeBaseDetail();
            objCreateUserId = changeBaseDetail.getCreateUserId();
            actUnifyTodoQryExtBo.setActivityCode(changeBaseDetail.getChangeCode());
        }
        rspBO.setObjCreateUserId(objCreateUserId);
        rspBO.setParamJson(JSONObject.toJSONString(actUnifyTodoQryExtBo));

        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }

    private void check(ActUnifyTodoQryReqBO reqBO){
        if(null == reqBO.getShareId()){
            throw new ZTBusinessException("分库建id不能为空");
        }
//        if(null == reqBO.getObjId()){
//            throw new ZTBusinessException("单据ID不能为空");
//        }
        if(null == reqBO.getObjType()){
            throw new ZTBusinessException("单据类型不能为空");
        }
    }
}
