package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActUpdateActivityStateService;
import com.tydic.dyc.act.service.bo.DycActUpdateActivityStateReqBO;
import com.tydic.dyc.act.service.bo.DycActUpdateActivityStateRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;

/**
 * 标题：DycActUpdateActivityStateServiceImpl
 * 说明：
 * 时间： 2024-04-01 10:46
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActUpdateActivityStateServiceImpl implements DycActUpdateActivityStateService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActUpdateActivityStateRspBO updateActivityState(DycActUpdateActivityStateReqBO reqBO) {
        checkParam(reqBO);
        DycActivityDO dycActivityDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityDO.class);
        dycActivityDO.setOperTypeSync(reqBO.getOperType());
        dycActActivityModel.updateActivityState(dycActivityDO);
        DycActUpdateActivityStateRspBO rspBO = new DycActUpdateActivityStateRspBO();
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }

    public void checkParam(DycActUpdateActivityStateReqBO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("参数为空！");
        }
    }
}
