package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.ActActivitySyncExternalRecordDO;
import com.tydic.dyc.act.service.api.DycActUpdateActivitySyncExternalRecordService;
import com.tydic.dyc.act.service.bo.DycActUpdateActivitySyncExternalRecordReqBO;
import com.tydic.dyc.act.service.bo.DycActUpdateActivitySyncExternalRecordRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycACTUpdateActivitySyncExternalRecordServiceImpl
 * 说明：
 * 时间： 2024-04-12 10:18
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActUpdateActivitySyncExternalRecordServiceImpl implements DycActUpdateActivitySyncExternalRecordService {

    @Autowired
    private DycActActivityModel dycActActivityModel;


    @Override
    public DycActUpdateActivitySyncExternalRecordRspBO updateActivitySyncExternalRecord(DycActUpdateActivitySyncExternalRecordReqBO reqBO) {
        ActActivitySyncExternalRecordDO recordDO = JSON.parseObject(JSON.toJSONString(reqBO.getRecordBO()), ActActivitySyncExternalRecordDO.class);
        dycActActivityModel.updateActivitySyncExternalRecord(recordDO);
        DycActUpdateActivitySyncExternalRecordRspBO rspBO = new DycActUpdateActivitySyncExternalRecordRspBO();
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
