package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.model.bo.DycActivityUserInfo;
import com.tydic.dyc.act.service.api.DycActUpdateActivityUserInfoService;
import com.tydic.dyc.act.service.bo.DycActUpdateActivityStateReqBO;
import com.tydic.dyc.act.service.bo.DycActUpdateActivityUserInfoReqBO;
import com.tydic.dyc.act.service.bo.DycActUpdateActivityUserInfoRspBO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

/**
 * 标题：DycActUpdateActivityUserInfoServiceImpl
 * 说明：根据条件修改活动用户信息表
 * 时间：2024/4/18
 *
 * @author zhoujie
 */
@HTServiceImpl
@Slf4j
public class DycActUpdateActivityUserInfoServiceImpl implements DycActUpdateActivityUserInfoService {

    @Autowired
    private DycActActivityModel dycActActivityModel;
    @Override
    public DycActUpdateActivityUserInfoRspBO updateActivityUserInfo(DycActUpdateActivityUserInfoReqBO reqBO) {
        checkParam(reqBO);
        DycActivityUserInfo dycActivityUserInfoWhere = new DycActivityUserInfo();
        dycActivityUserInfoWhere.setActivityId(reqBO.getActivityId());
        dycActivityUserInfoWhere.setId(reqBO.getId());
        dycActivityUserInfoWhere.setIds(reqBO.getIds());
        DycActivityUserInfo dycActivityUserInfoSet = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityUserInfo.class);
        try {
            int i = dycActActivityModel.updateActivityUserInfoBy(dycActivityUserInfoSet, dycActivityUserInfoWhere);
        }catch (Exception e){
            log.error("修改活动用户信息失败:{}",e.getMessage());
            throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR,"修改活动用户信息失败");
        }
        DycActUpdateActivityUserInfoRspBO rspBO = new DycActUpdateActivityUserInfoRspBO();
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }

    public void checkParam(DycActUpdateActivityUserInfoReqBO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR,"入参不能为空");
        }
        if (CollectionUtils.isEmpty(reqBO.getIds())) {
            throw new BaseBusinessException(DycActivityRspConstants.RSP_CODE_ACT_EMPTY_ERROR,"Id集合不能为空");
        }
    }
}
