package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActUpdateCommodityState;
import com.tydic.dyc.act.service.bo.DycActActivityInfoBO;
import com.tydic.dyc.act.service.bo.DycActBatchSelectActivityCommodityRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActUpdateCommodityStateImpl
 * 说明：
 * 时间： 2024-04-17 16:58
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActUpdateCommodityStateImpl implements DycActUpdateCommodityState {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActBatchSelectActivityCommodityRspBO updateCommodityState(DycActActivityInfoBO reqBO) {
        DycActivityDO recordDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityDO.class);
        dycActActivityModel.updateCommodityState(recordDO);
        DycActBatchSelectActivityCommodityRspBO rspBO = new DycActBatchSelectActivityCommodityRspBO();
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
