package com.tydic.dyc.act.service.impl;

import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.service.api.DycActUpdateIntegralZeroClearanceUserService;
import com.tydic.dyc.act.service.bo.DycActUpdateIntegralZeroClearanceUserReqBo;
import com.tydic.dyc.act.service.bo.DycActUpdateIntegralZeroClearanceUserRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActUpdateIntegralZeroClearanceUserServiceImpl
 * 说明：活动变更-积分清零API实现类
 * 时间：2024/4/16 10:07 上午
 * 作者：汪成松
 */
@HTServiceImpl
public class DycActUpdateIntegralZeroClearanceUserServiceImpl implements DycActUpdateIntegralZeroClearanceUserService {

    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;

    @Override
    public DycActUpdateIntegralZeroClearanceUserRspBo updateIntegralZeroClearance(DycActUpdateIntegralZeroClearanceUserReqBo reqBo) {
        DycActivityChangeDO dycActivityChangeDo = new DycActivityChangeDO();
        dycActivityChangeDo.setUpdateUserId(reqBo.getUserId());
        dycActivityChangeDo.setUpdateUserName(reqBo.getName());
        dycActivityChangeDo.setUserIdList(reqBo.getUserIdList());
        dycActivityChangeDo.setChangeId(reqBo.getChangeId());
        dycActivityChangeModel.batchModifyIntegralZeroClearance(dycActivityChangeDo);
        DycActUpdateIntegralZeroClearanceUserRspBo dycActUpdateIntegralZeroClearanceUserRspBo = new DycActUpdateIntegralZeroClearanceUserRspBo();
        dycActUpdateIntegralZeroClearanceUserRspBo.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        dycActUpdateIntegralZeroClearanceUserRspBo.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return dycActUpdateIntegralZeroClearanceUserRspBo;
    }
}
