package com.tydic.dyc.act.utils;

import com.tydic.dyc.act.constants.DycActivityConstants;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题：DycActivityTransFieldUtil
 * 说明：
 * 时间： 2023-12-12 17:15
 * 作者 @author LY
 */
public class DycActivityTransFieldUtil {

    /**
     * 发票类别
     */
    public static String InvoiceClass(String reqBO) {
        switch (reqBO) {
            case DycActivityConstants.InvoiceClass.INVOICE_CLASS_ONE:
                return DycActivityConstants.InvoiceClass.INVOICE_CLASS_ONE_STR;
            case DycActivityConstants.InvoiceClass.INVOICE_CLASS_TWO:
                return DycActivityConstants.InvoiceClass.INVOICE_CLASS_TWO_STR;
            default:
                return "错误";
        }
    }

    public static List<Integer> TaskStatus(String reqBO) {
        List<Integer> list = new ArrayList<>();
        if ("1".equals(reqBO)) {
            list.add(1);
        } else if ("2".equals(reqBO)) {
            list.add(2);
            list.add(3);
        } else {
            list.add(1);
            list.add(2);
            list.add(3);
        }
        return list;
    }

    /**
     * 发票类型
     */
    public static String InvoiceType(String reqBO) {
        switch (reqBO) {
            case DycActivityConstants.InvoiceType.INVOICE_TYPE_ONE:
                return DycActivityConstants.InvoiceType.INVOICE_TYPE_ONE_STR;
            case DycActivityConstants.InvoiceType.INVOICE_TYPE_TWO:
                return DycActivityConstants.InvoiceType.INVOICE_TYPE_TWO_STR;
            default:
                return "错误";
        }
    }

    /**
     * 活动类型
     */
    public static String ActivityType(String reqBO) {
        switch (reqBO) {
            case DycActivityConstants.ActivityType.ACTIVITY_TYPE_ONE:
                return DycActivityConstants.ActivityType.ACTIVITY_TYPE_ONE_STR;
            case DycActivityConstants.ActivityType.ACTIVITY_TYPE_TWO:
                return DycActivityConstants.ActivityType.ACTIVITY_TYPE_TWO_STR;
            default:
                return "错误";
        }
    }

    public static String SkuStatusStr(String reqBO) {
        switch (reqBO) {
            case "1":
                return DycActivityConstants.SkuStatue.ON_SALE_STR;
            case "2":
                return DycActivityConstants.SkuStatue.WITHDRAWN_STR;
            case "0":
                return DycActivityConstants.SkuStatue.DELETE_STR;
            default:
                return "错误";
        }
    }

    public static String ActivitySyncState(String reqBO) {
        switch (reqBO) {
            case "1":
                return "待同步";
            case "2":
                return "同步中";
            case "3":
                return "同步成功";
            case "4":
                return "同步失败";
            default:
                return "错误";
        }
    }

    public static String CommodityRelaMethodSTR(String reqBO) {
        switch (reqBO) {
            case DycActivityConstants.CommodityRelaMethod.COMMODITY_TYPE_ONE:
                return DycActivityConstants.CommodityRelaMethod.COMMODITY_TYPE_ONE_STR;
            case DycActivityConstants.CommodityRelaMethod.COMMODITY_TYPE_TWO:
                return DycActivityConstants.CommodityRelaMethod.COMMODITY_TYPE_TWO_STR;
            case DycActivityConstants.CommodityRelaMethod.COMMODITY_TYPE_THREE:
                return DycActivityConstants.CommodityRelaMethod.COMMODITY_TYPE_THREE_STR;
            default:
                return "错误";
        }
    }

    /**
     * 支付方式
     */
    public static String ActivityPayMode(String reqBO) {
        switch (reqBO) {
            case DycActivityConstants.ActivityPayMode.ACTIVITY_PAY_MODE_ONE:
                return DycActivityConstants.ActivityPayMode.ACTIVITY_PAY_MODE_ONE_STR;
            case DycActivityConstants.ActivityPayMode.ACTIVITY_PAY_MODE_TWO:
                return DycActivityConstants.ActivityPayMode.ACTIVITY_PAY_MODE_TWO_STR;
            default:
                return "错误";
        }
    }


    /**
     * 活动状态
     */
    public static String ActivityState(String reqBO) {
        switch (reqBO) {
            case DycActivityConstants.ActivityState.ACTIVITY_STATE_ONE:
                return DycActivityConstants.ActivityState.ACTIVITY_STATE_ONE_STR;
            case DycActivityConstants.ActivityState.ACTIVITY_STATE_TWO:
                return DycActivityConstants.ActivityState.ACTIVITY_STATE_TWO_STR;
            case DycActivityConstants.ActivityState.ACTIVITY_STATE_THREE:
                return DycActivityConstants.ActivityState.ACTIVITY_STATE_THREE_STR;
            case DycActivityConstants.ActivityState.ACTIVITY_STATE_FOUR:
                return DycActivityConstants.ActivityState.ACTIVITY_STATE_FOUR_STR;
            case DycActivityConstants.ActivityState.ACTIVITY_STATE_FIVE:
                return DycActivityConstants.ActivityState.ACTIVITY_STATE_FIVE_STR;
            case DycActivityConstants.ActivityState.ACTIVITY_STATE_SIX:
                return DycActivityConstants.ActivityState.ACTIVITY_STATE_SIX_STR;
            case DycActivityConstants.ActivityState.ACTIVITY_STATE_SEVEN:
                return DycActivityConstants.ActivityState.ACTIVITY_STATE_SEVEN_STR;
            case DycActivityConstants.ActivityState.ACTIVITY_STATE_EIGHT:
                return DycActivityConstants.ActivityState.ACTIVITY_STATE_EIGHT_STR;
            default:
                return "错误";
        }
    }

    /**
     * 附件业务对象类型
     */
    public static String BusinessObject(String reqBO) {
        switch (reqBO) {
            case DycActivityConstants.BusinessObject.BUSINESS_OBJECT_MODE_ONE:
                return DycActivityConstants.BusinessObject.BUSINESS_OBJECT_MODE_ONE_STR;
            case DycActivityConstants.BusinessObject.BUSINESS_OBJECT_MODE_TWO:
                return DycActivityConstants.BusinessObject.BUSINESS_OBJECT_MODE_TWO_STR;
            case DycActivityConstants.BusinessObject.BUSINESS_OBJECT_MODE_THREE:
                return DycActivityConstants.BusinessObject.BUSINESS_OBJECT_MODE_THREE_STR;
            default:
                return "错误";
        }
    }

    /**
     * 活动变更状态
     */
    public static String ChangeState(String reqBO) {
        switch (reqBO) {
            case DycActivityConstants.ChangeState.CHANGE_STATE_ZERO:
                return DycActivityConstants.ChangeState.CHANGE_STATE_ZERO_STR;
            case DycActivityConstants.ChangeState.CHANGE_STATE_ONE:
                return DycActivityConstants.ChangeState.CHANGE_STATE_ONE_STR;
            case DycActivityConstants.ChangeState.CHANGE_STATE_TWO:
                return DycActivityConstants.ChangeState.CHANGE_STATE_TWO_STR;
            case DycActivityConstants.ChangeState.CHANGE_STATE_THREE:
                return DycActivityConstants.ChangeState.CHANGE_STATE_THREE_STR;
            default:
                return "错误";
        }
    }

    public static String ACT_STATE(String reqBO) {
        switch (reqBO) {
            case DycActivityConstants.TAB_ID.TAB_ID_1:
                return DycActivityConstants.ACT_STATE.TAB_ID_1_STATE;
            case DycActivityConstants.TAB_ID.TAB_ID_2:
                return DycActivityConstants.ACT_STATE.TAB_ID_2_STATE;
            case DycActivityConstants.TAB_ID.TAB_ID_3:
                return DycActivityConstants.ACT_STATE.TAB_ID_3_STATE;
            case DycActivityConstants.TAB_ID.TAB_ID_4:
                return DycActivityConstants.ACT_STATE.TAB_ID_4_STATE;
            default:
                return "错误";
        }
    }

    /**
     * 使用类型
     */
    public static String UseType(String reqBO) {
        switch (reqBO) {
            case DycActivityConstants.UseType.USE_TYPE_ONE:
                return DycActivityConstants.UseType.USE_TYPE_ONE_STR;
            case DycActivityConstants.UseType.USE_TYPE_TWO:
                return DycActivityConstants.UseType.USE_TYPE_TWO_STR;
            case DycActivityConstants.UseType.USE_TYPE_THREE:
                return DycActivityConstants.UseType.USE_TYPE_THREE_STR;
            case DycActivityConstants.UseType.USE_TYPE_FOUR:
                return DycActivityConstants.UseType.USE_TYPE_FOUR_STR;
            default:
                return "错误";
        }
    }

    public static String SyncStepStr(String reqBO){
        switch (reqBO){
            case "SYNC_BASE_INFO":
                return "活动信息同步";
            case "SYNC_COMMODITY":
                return "活动商品同步";
            case "SYNC_USER":
                return "用户信息同步";
            case "SYNC_SCORES":
                return "活动积分同步";
            default:
                return "错误";
        }
    }

    public static String SyncResultStr(String reqBO){
        switch (reqBO){
            case "PENDING":
                return "待同步";
            case "UNDERWAY":
                return "同步中";
            case "SUCCESS":
                return "同步成功";
            case "FAIL":
                return "同步失败";
            default:
                return "错误";
        }
    }
}
