package com.tydic.dyc.act.utils;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Value;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

/**
 * 描述：处理Excel的方法
 *
 * @Author xiasd
 * @Date 0:50 2020/8/6
 */
@Slf4j
public class ExcelNewUtils {
	private static final String EXCEL_XLS = "xls";
	private static final String EXCEL_XLSX = "xlsx";

	private static final String PATH = "dyc-common";
	@Value("${plugin.file.type}")
	private static String fileType;
	@Value("${oss.fileUrl:}")
	private static String ossFileUrl;

	public static void getExcelDate(String urlLocation, List<List<String>> data, Integer readLine, Integer sheetAt, FileClient fileClient) throws Exception {

		int count = 1;
		try {
			log.info("请求读 {}", urlLocation);
//            String requestUri = urlLocation.substring(urlLocation.indexOf(downloadFile) + downloadFile.length());
			if (urlLocation.startsWith("/")) {
				urlLocation = urlLocation.substring(1);
			}
			String s = URLDecoder.decode(urlLocation, "utf-8");
			log.info("替换后的路径 {} ", s);
			//获取数据流
			InputStream inputStream = fileClient.downLoadToInputStream(s);
			checkExcelVaild(urlLocation);


//            FileInputStream fileInputStream = new FileInputStream(new File("D:/商品导入.xlsx"));
//            Workbook workbook = getWorkbok(path,fileInputStream);

			Workbook workbook ;
			// 将输入流转换为工作簿对象
			if(urlLocation.endsWith(".xls")){
				workbook = new HSSFWorkbook(inputStream);
			} else {
				workbook = new XSSFWorkbook(inputStream);
			}
			Sheet sheet = workbook.getSheetAt(sheetAt);
			for (Row row : sheet) {
				List<String> c = new ArrayList<>();
				int end = row.getLastCellNum();
				//如果当前行没有数据，跳出循环
				if (row.getCell(0) == null || "".equals(row.getCell(0).toString())) {
					continue;
				}
				// int lastColumn = Math.max(r.getLastCellNum(), MY_MINIMUM_COLUMN_COUNT);
				for (int i = 0; i < end; i++) {
					Cell cell = row.getCell(i, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
					if (count >= readLine) {
						if (cell == null) {
							c.add("");
							continue;
						}
						Object obj = getValue(cell);

						c.add(String.valueOf(obj).trim());
					}
				}
				count++;
				if (c.size() > 0) {
					data.add(c);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new ZTBusinessException("第" + count + "数据处理失败，原因：" + e.getMessage());
		}
	}

	/**
	 * 判断文件是否是excel
	 *
	 * @throws Exception
	 */
	private static void checkExcelVaild(String filePath) throws Exception {
		if (filePath == null) {
			return;
		}
		String extString = filePath.substring(filePath.lastIndexOf(".") + 1);
		if (!EXCEL_XLS.equals(extString) && !EXCEL_XLSX.equals(extString)) {
			throw new Exception("文件不是Excel");
		}
	}

	/**
	 * 判断Excel的版本,获取Workbook
	 *
	 * @param filePath
	 * @return
	 * @throws IOException
	 */
	private static Workbook getWorkbok(String filePath, InputStream inputStream) throws IOException {
		if (filePath == null) {
			return null;
		}
		String extString = filePath.substring(filePath.lastIndexOf(".") + 1);
		if (!EXCEL_XLS.equals(extString) && !EXCEL_XLSX.equals(extString)) {
			throw new IOException("文件不是Excel");
		}
		Workbook wb = null;
		if (EXCEL_XLS.equals(extString)) {  //Excel 2003
			wb = new HSSFWorkbook(inputStream);

		} else if (EXCEL_XLSX.equals(extString)) {  // Excel 2007/2010
			wb = new XSSFWorkbook(inputStream);
		}
		return wb;
	}

	private static Object getValue(Cell cell) {
		Object obj = null;
//        cell.setCellType(STRING);
		switch (cell.getCellTypeEnum()) {
			case BOOLEAN:
				obj = cell.getBooleanCellValue();
				break;
			case ERROR:
				obj = cell.getErrorCellValue();
				break;
			case NUMERIC:
				// 格式化数字，去掉小数位
				DecimalFormat decimalFormat = new DecimalFormat("#");
				obj = decimalFormat.format(cell.getNumericCellValue());
				break;
			case STRING:
				obj = cell.getStringCellValue();
				break;
			default:
				break;
		}
		return obj;
	}

	public static void main(String[] args) throws Exception {
		checkExcelVaild("https://" + ossFileUrl + PATH + "/无协议导入商品模板." + EXCEL_XLSX);
		int num = 0;
		try {
			for (int i = 0; i < 3; i++) {
				num++;
				i = 1 / 0;
			}
		} catch (Exception e) {
			System.out.println(num);
		}
	}
}
