/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.model.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.act.model.api.ActSysDictionaryModel;
import com.tydic.dyc.act.model.bo.ActSysDictionaryBO;
import com.tydic.dyc.act.model.bo.ActSysDictionaryQryBO;
import com.tydic.dyc.act.repository.api.ActSysDictionaryRepository;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActSysDictionaryModelImpl
implements ActSysDictionaryModel {
    @Autowired
    private ActSysDictionaryRepository actSysDictionaryRepository;

    @Override
    public Map<String, Map<String, String>> getDictionaryMap(List<String> pCodes) {
        ActSysDictionaryQryBO actSysDictionaryQryBO = new ActSysDictionaryQryBO();
        actSysDictionaryQryBO.setPCodes(pCodes);
        List<ActSysDictionaryBO> sysDictionaryBOList = this.actSysDictionaryRepository.getList(actSysDictionaryQryBO);
        HashMap<String, Map<String, String>> dicPCodeAndCodeMap = new HashMap<String, Map<String, String>>();
        if (ObjectUtil.isNotEmpty(sysDictionaryBOList)) {
            Map<String, List<ActSysDictionaryBO>> dicPCodeMap = sysDictionaryBOList.stream().collect(Collectors.groupingBy(ActSysDictionaryBO::getPCode));
            for (String pCode : dicPCodeMap.keySet()) {
                Map<String, String> dicCodeMap = dicPCodeMap.get(pCode).stream().collect(Collectors.toMap(ActSysDictionaryBO::getCode, ActSysDictionaryBO::getDescrip, (k1, k2) -> k2));
                dicPCodeAndCodeMap.put(pCode, dicCodeMap);
            }
        }
        return dicPCodeAndCodeMap;
    }
}

