/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.model.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.constants.ActConstants;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.ActActivityCommodityCatalogSumDO;
import com.tydic.dyc.act.model.bo.ActActivitySyncExternalRecordDO;
import com.tydic.dyc.act.model.bo.ActActivitySyncExternalRecordInfo;
import com.tydic.dyc.act.model.bo.ActAlertOrderInfo;
import com.tydic.dyc.act.model.bo.ActNotifyDelayListRspBO;
import com.tydic.dyc.act.model.bo.ActNotifyDelayReqBO;
import com.tydic.dyc.act.model.bo.ActSelectQueryCatalogTreeReqBO;
import com.tydic.dyc.act.model.bo.ActSkuInfoBO;
import com.tydic.dyc.act.model.bo.DycActActivityInfo;
import com.tydic.dyc.act.model.bo.DycActActivityRelaCommodityInfo;
import com.tydic.dyc.act.model.bo.DycActDealOrderAlertDO;
import com.tydic.dyc.act.model.bo.DycActFscOrderDO;
import com.tydic.dyc.act.model.bo.DycActGuideDO;
import com.tydic.dyc.act.model.bo.DycActImportActivityCommodityInfo;
import com.tydic.dyc.act.model.bo.DycActImportActivityCommodityModelReqBO;
import com.tydic.dyc.act.model.bo.DycActImportActivityCommodityModelRspBO;
import com.tydic.dyc.act.model.bo.DycActImportActivityInfoModelBO;
import com.tydic.dyc.act.model.bo.DycActImportActivityUserModelReqBO;
import com.tydic.dyc.act.model.bo.DycActImportActivityUserModelRspBO;
import com.tydic.dyc.act.model.bo.DycActOrderInfo;
import com.tydic.dyc.act.model.bo.DycActQryActInfoByUserQryDO;
import com.tydic.dyc.act.model.bo.DycActSceneInfo;
import com.tydic.dyc.act.model.bo.DycActSceneInfoDO;
import com.tydic.dyc.act.model.bo.DycActUserScoresBaseInfo;
import com.tydic.dyc.act.model.bo.DycActUserScoresBaseInfoQueryBO;
import com.tydic.dyc.act.model.bo.DycActUserScoresBaseInfoRspBO;
import com.tydic.dyc.act.model.bo.DycActiveBaseInfoSaveReqBO;
import com.tydic.dyc.act.model.bo.DycActiveCommodityCatalogInfo;
import com.tydic.dyc.act.model.bo.DycActiveCommodityCatalogQueryBO;
import com.tydic.dyc.act.model.bo.DycActivityBaseInfo;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.model.bo.DycActivityChangeInfo;
import com.tydic.dyc.act.model.bo.DycActivityCommodityPoolInfo;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.model.bo.DycActivityFileInfo;
import com.tydic.dyc.act.model.bo.DycActivitySupplierInfo;
import com.tydic.dyc.act.model.bo.DycActivitySupplierInfoAddBatchBO;
import com.tydic.dyc.act.model.bo.DycActivitySupplierInfoDeleteBatchBO;
import com.tydic.dyc.act.model.bo.DycActivityUserInfo;
import com.tydic.dyc.act.model.bo.DycActivityUserScoresUseRecordInfo;
import com.tydic.dyc.act.model.bo.DycQueryActivityCommodityPoolPageListReqBO;
import com.tydic.dyc.act.model.bo.DycSaasActQueryActivityUserPageListRspBO;
import com.tydic.dyc.act.repository.api.ActActivityCommodityCatalogSumRepository;
import com.tydic.dyc.act.repository.api.ActNotifyDelayRepository;
import com.tydic.dyc.act.repository.api.DycActActivityChangeCommodityCatalogInComRepository;
import com.tydic.dyc.act.repository.api.DycActActivityChangeRepository;
import com.tydic.dyc.act.repository.api.DycActActivityCommodityCatalogInComRepository;
import com.tydic.dyc.act.repository.api.DycActActivityCommodityRepository;
import com.tydic.dyc.act.repository.api.DycActActivityRepository;
import com.tydic.dyc.act.repository.api.DycActActivitySupplierRepository;
import com.tydic.dyc.act.repository.api.DycActActivitySyncExternalRecordRepository;
import com.tydic.dyc.act.repository.api.DycActActivityUserRepository;
import com.tydic.dyc.act.repository.api.DycActAlertInfoRepository;
import com.tydic.dyc.act.repository.api.DycActConfigRepository;
import com.tydic.dyc.act.repository.api.DycActFileRepository;
import com.tydic.dyc.act.repository.api.DycActOrderInfoRepository;
import com.tydic.dyc.act.repository.api.DycActSkuInfoRepository;
import com.tydic.dyc.act.service.bo.DycActActivitySupplierInfoBO;
import com.tydic.dyc.act.service.bo.DycActActivityUserInfoBO;
import com.tydic.dyc.act.service.bo.DycActCheckUserNotScoreReqBo;
import com.tydic.dyc.act.service.bo.DycActCheckUserNotScoreRspBo;
import com.tydic.dyc.base.bo.BasePageRspBo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class DycActActivityModelImpl
implements DycActActivityModel {
    private static final Logger log = LoggerFactory.getLogger(DycActActivityModelImpl.class);
    @Autowired
    private DycActAlertInfoRepository dycActAlertInfoRepository;
    @Autowired
    private DycActActivityRepository dycActActivityRepository;
    @Autowired
    private DycActFileRepository dycActFileRepository;
    @Autowired
    private DycActActivitySupplierRepository dycActActivitySupplierRepository;
    @Autowired
    private DycActActivityCommodityRepository dycActActivityCommodityRepository;
    @Autowired
    private DycActActivityCommodityCatalogInComRepository dycActActivityCommodityCatalogInComRepository;
    @Autowired
    private DycActActivityUserRepository dycActActivityUserRepository;
    @Autowired
    private DycActConfigRepository dycActConfigRepository;
    @Autowired
    private DycActSkuInfoRepository dycActSkuInfoRepository;
    @Autowired
    private DycActActivitySyncExternalRecordRepository dycActActivitySyncExternalRecordRepository;
    @Autowired
    private DycActOrderInfoRepository dycActOrderInfoRepository;
    @Autowired
    private DycActActivityChangeRepository dycActActivityChangeRepository;
    @Autowired
    private ActActivityCommodityCatalogSumRepository actActivityCommodityCatalogSumRepository;
    @Autowired
    private DycActActivityChangeCommodityCatalogInComRepository dycActActivityChangeCommodityCatalogInComRepository;
    @Autowired
    private ActNotifyDelayRepository actNotifyDelayRepository;

    @Override
    public int updateLoseActivityAlertType(DycActivityBaseInfo set, DycActivityBaseInfo where) {
        return this.dycActActivityRepository.updateLoseActivityAlertType(set, where);
    }

    @Override
    public BasePageRspBo<DycActivityBaseInfo> queryActivityPageList(DycActivityDO reqBO) {
        ArrayList<Long> actId;
        BasePageRspBo<DycActivityBaseInfo> rspBo = this.dycActActivityRepository.queryActivityPageList(reqBO);
        if (!CollectionUtils.isEmpty((Collection)rspBo.getRows()) && null != reqBO.getFlagQry()) {
            actId = new ArrayList<Long>();
            ArrayList<String> actCode = new ArrayList<String>();
            rspBo.getRows().forEach(item -> {
                actId.add((Long)((Object)item.getExtActivityId()));
                actCode.add(item.getActivityCode());
            });
            Map<Object, Object> actOrderInfoMap = new HashMap();
            Map<Object, Object> changeInfoMap = new HashMap();
            List<DycActOrderInfo> orderInfos = this.dycActOrderInfoRepository.qryActSum(actId);
            List<DycActivityChangeInfo> changeInfos = this.dycActActivityChangeRepository.qrySum(actCode);
            if (!CollectionUtils.isEmpty(orderInfos)) {
                Map<Object, Object> finalActOrderInfoMap = actOrderInfoMap = orderInfos.stream().collect(Collectors.toMap(DycActOrderInfo::getExtActivityId, item -> item));
                rspBo.getRows().forEach(item -> {
                    if (finalActOrderInfoMap.containsKey(item.getExtActivityId()) && ((DycActOrderInfo)finalActOrderInfoMap.get(item.getExtActivityId())).getTotal() > 0) {
                        item.setOrderFalg(true);
                        item.setScores(true);
                    }
                });
            }
            if (!CollectionUtils.isEmpty(changeInfos)) {
                Map<Object, Object> finalChangeInfoMap = changeInfoMap = changeInfos.stream().collect(Collectors.toMap(DycActivityChangeInfo::getOriginalActivityCode, item -> item));
                rspBo.getRows().forEach(item -> {
                    if (finalChangeInfoMap.containsKey(item.getActivityCode()) && ((DycActivityChangeInfo)finalChangeInfoMap.get(item.getActivityCode())).getTotal() > 0) {
                        item.setChangeFalg(true);
                    }
                });
            }
        }
        if (!CollectionUtils.isEmpty((Collection)rspBo.getRows()) && null != reqBO.getSupplierFlag()) {
            actId = new ArrayList();
            rspBo.getRows().forEach(item -> actId.add(item.getActivityId()));
            DycActivitySupplierInfo supplierInfo = new DycActivitySupplierInfo();
            supplierInfo.setActivityIds(actId);
            List<DycActivitySupplierInfo> infoList = this.dycActActivitySupplierRepository.batchQrySupplier(supplierInfo);
            if (!CollectionUtils.isEmpty(infoList)) {
                Map<Long, List<DycActivitySupplierInfo>> collect = infoList.stream().collect(Collectors.groupingBy(DycActivitySupplierInfo::getActivityId));
                rspBo.getRows().forEach(item -> {
                    List supplierInfos = (List)collect.get(item.getActivityId());
                    if (!CollectionUtils.isEmpty((Collection)supplierInfos)) {
                        item.setActivitySupplierList(JSON.parseArray((String)JSON.toJSONString((Object)supplierInfos), DycActActivitySupplierInfoBO.class));
                        item.setSupplierName(((DycActivitySupplierInfo)((Object)((Object)supplierInfos.get(0)))).getSupplierName());
                    }
                });
            }
        }
        return rspBo;
    }

    @Override
    public List<DycActivityBaseInfo> queryActivityId(DycActivityDO reqBO) {
        List<DycActivityBaseInfo> baseInfos = this.dycActActivityRepository.queryActivityId(reqBO);
        if (!CollectionUtils.isEmpty(baseInfos)) {
            ArrayList<String> actCode = new ArrayList<String>();
            baseInfos.forEach(item -> actCode.add(item.getActivityCode()));
            List<DycActivityChangeInfo> changeInfos = this.dycActActivityChangeRepository.qrySum(actCode);
            if (!CollectionUtils.isEmpty(changeInfos)) {
                Map<String, DycActivityChangeInfo> changeInfoMap;
                Map<String, DycActivityChangeInfo> finalChangeInfoMap = changeInfoMap = changeInfos.stream().collect(Collectors.toMap(DycActivityChangeInfo::getOriginalActivityCode, item -> item));
                baseInfos.forEach(item -> {
                    if (finalChangeInfoMap.containsKey(item.getActivityCode()) && ((DycActivityChangeInfo)finalChangeInfoMap.get(item.getActivityCode())).getTotal() > 0) {
                        item.setChangeFalg(true);
                    }
                });
            }
        }
        return baseInfos;
    }

    @Override
    public List<DycActivityBaseInfo> queryActivityList(DycActivityDO reqBO) {
        return this.dycActActivityRepository.queryActivityList(reqBO);
    }

    @Override
    public DycActivityBaseInfo getModelByNew(DycActivityBaseInfo reqBO) {
        return this.dycActActivityRepository.getModelByNew(reqBO);
    }

    @Override
    public List<DycActivityFileInfo> queryActivityFileList(DycActivityDO reqBO) {
        return this.dycActFileRepository.queryActivityFileList(reqBO);
    }

    @Override
    public BasePageRspBo<DycActivitySupplierInfo> queryActivityUnselectSupplierPageList(DycActivityDO reqBO) {
        return this.dycActActivitySupplierRepository.queryActivityUnselectSupplierPageList(reqBO);
    }

    @Override
    public BasePageRspBo<DycActivitySupplierInfo> queryActiveSupplierList(DycActivityDO reqBO) {
        return this.dycActActivitySupplierRepository.queryActiveSupplierList(reqBO);
    }

    @Override
    public DycActivitySupplierInfo addBatchActiveSupplier(DycActivitySupplierInfoAddBatchBO reqBO) {
        return this.dycActActivitySupplierRepository.addBatchActiveSupplier(reqBO);
    }

    @Override
    public DycActivitySupplierInfo deleteBatchActiveSupplier(DycActivitySupplierInfoDeleteBatchBO reqBO) {
        return this.dycActActivitySupplierRepository.deleteBatchActiveSupplier(reqBO);
    }

    @Override
    public DycActivityBaseInfo saveActiveBaseInfo(DycActiveBaseInfoSaveReqBO reqBO) {
        log.info("\u5165\u53c2\u5f00\u59cb\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        DycActivityBaseInfo baseInfo = this.dycActActivityRepository.saveActiveBaseInfo(reqBO);
        if (null != reqBO.getActivityId() && !CollectionUtils.isEmpty(reqBO.getActivitySupplierList())) {
            DycActivitySupplierInfoDeleteBatchBO deleteBO = new DycActivitySupplierInfoDeleteBatchBO();
            deleteBO.setActivityId(reqBO.getActivityId());
            this.dycActActivitySupplierRepository.deleteActiveSupplier(deleteBO);
            DycActivitySupplierInfoAddBatchBO addBatchBO = new DycActivitySupplierInfoAddBatchBO();
            addBatchBO.setActivityId(reqBO.getActivityId());
            addBatchBO.setSupplierList(reqBO.getActivitySupplierList());
            this.dycActActivitySupplierRepository.addBatchActiveSupplier(addBatchBO);
        }
        DycActivityBaseInfo rspBO = new DycActivityBaseInfo();
        rspBO.setActivityId(baseInfo.getActivityId());
        return rspBO;
    }

    @Override
    public BasePageRspBo<DycActivityCommodityPoolInfo> queryActivityCommodityPoolPageList(DycQueryActivityCommodityPoolPageListReqBO reqBO) {
        return this.dycActActivityCommodityRepository.queryActivityCommodityPoolPageList(reqBO);
    }

    @Override
    public BasePageRspBo<DycActActivityRelaCommodityInfo> queryActivityCommodityPageList(DycActivityDO reqBO) {
        return this.dycActActivityCommodityRepository.queryActivityCommodityPageList(reqBO);
    }

    @Override
    public BasePageRspBo<DycActActivityRelaCommodityInfo> queryActivityCommodityCatalogInComPageList(DycActivityDO reqBO) {
        return this.dycActActivityCommodityCatalogInComRepository.queryActivityCommodityPageList(reqBO);
    }

    @Override
    public void updateBatch(List<DycActActivityRelaCommodityInfo> list) {
        this.dycActActivityCommodityRepository.updateBatch(list);
    }

    @Override
    public List<DycActActivityRelaCommodityInfo> queryActivityCommodityList(DycActivityDO reqBO) {
        return this.dycActActivityCommodityRepository.queryActivityCommodityList(reqBO);
    }

    @Override
    public BasePageRspBo<DycActiveCommodityCatalogInfo> queryActiveCommodityCatalogList(DycActiveCommodityCatalogQueryBO reqBO) {
        return this.dycActActivityCommodityRepository.queryActiveCommodityCatalogList(reqBO);
    }

    @Override
    public DycActivityCommodityPoolInfo batchSelectActivityCommodityPool(DycActivityDO reqBO) {
        return this.dycActActivityCommodityRepository.batchSelectActivityCommodityPool(reqBO);
    }

    @Override
    public int batchRemoveActivityCommodityPool(DycActivityDO reqBO) {
        return this.dycActActivityCommodityRepository.batchRemoveActivityCommodityPool(reqBO);
    }

    @Override
    public DycActiveCommodityCatalogInfo batchSelectActivityCommodityCatalog(DycActivityDO reqBO) {
        DycActiveCommodityCatalogInfo rspBO = new DycActiveCommodityCatalogInfo();
        if (!CollectionUtils.isEmpty(reqBO.getCommodityCatalogInfoBOS())) {
            this.dycActActivityCommodityRepository.batchSelectActivityCommodityCatalog(reqBO);
            int commodityCatalog = this.dycActActivityCommodityRepository.selectCountCommodityCatalog(reqBO);
            DycActivityDO activityDO = new DycActivityDO();
            activityDO.setActivityId(reqBO.getActivityId());
            activityDO.setTotalCatalog(commodityCatalog);
            this.dycActActivityRepository.updateActivityState(activityDO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getActActivityRelaCommodityBOS())) {
            this.dycActActivityCommodityCatalogInComRepository.batchSelectActivityCommodity(reqBO);
        }
        return rspBO;
    }

    @Override
    public int batchRemoveActivityCommodityCatalog(DycActivityDO reqBO) {
        int i = this.dycActActivityCommodityRepository.batchRemoveActivityCommodityCatalog(reqBO);
        if (!CollectionUtils.isEmpty(reqBO.getThreeCatalogIds())) {
            DycActActivityRelaCommodityInfo commodityInfo = new DycActActivityRelaCommodityInfo();
            commodityInfo.setActivityId(reqBO.getActivityId());
            commodityInfo.setThreeCatalogIds(reqBO.getThreeCatalogIds());
            this.dycActActivityCommodityCatalogInComRepository.updateByThreeCatalogIds(commodityInfo);
        }
        int commodityCatalog = this.dycActActivityCommodityRepository.selectCountCommodityCatalog(reqBO);
        DycActivityDO activityDO = new DycActivityDO();
        activityDO.setActivityId(reqBO.getActivityId());
        activityDO.setTotalCatalog(commodityCatalog);
        this.dycActActivityRepository.updateActivityState(activityDO);
        return i;
    }

    @Override
    public DycActActivityRelaCommodityInfo batchSelectActivityCommodity(DycActivityDO reqBO) {
        DycActActivityRelaCommodityInfo rspBO = this.dycActActivityCommodityRepository.batchSelectActivityCommodity(reqBO);
        int countCommodity = this.dycActActivityCommodityRepository.selectCountCommodity(reqBO);
        DycActivityDO activityDO = new DycActivityDO();
        activityDO.setActivityId(reqBO.getActivityId());
        activityDO.setTotalCommodity(countCommodity);
        this.dycActActivityRepository.updateActivityState(activityDO);
        return rspBO;
    }

    @Override
    public int batchRemoveActivityCommodity(DycActivityDO reqBO) {
        int rspBO = this.dycActActivityCommodityRepository.batchRemoveActivityCommodity(reqBO);
        int countCommodity = this.dycActActivityCommodityRepository.selectCountCommodity(reqBO);
        DycActivityDO activityDO = new DycActivityDO();
        activityDO.setActivityId(reqBO.getActivityId());
        activityDO.setTotalCommodity(countCommodity);
        this.dycActActivityRepository.updateActivityState(activityDO);
        return rspBO;
    }

    @Override
    public DycSaasActQueryActivityUserPageListRspBO queryActivityUserPageList(DycActivityDO reqBO) {
        DycSaasActQueryActivityUserPageListRspBO rspBo = this.dycActActivityUserRepository.queryActivityUserPageList(reqBO);
        rspBo.setTotalScores(this.dycActActivityUserRepository.selectCountUserScores(reqBO));
        return rspBo;
    }

    @Override
    public int changeActivityState(DycActivityDO reqBO) {
        return this.dycActActivityRepository.changeActivityState(reqBO);
    }

    @Override
    public int deleteActivity(DycActivityDO reqBO) {
        int i = this.dycActActivityRepository.deleteActivity(reqBO);
        this.dycActActivityCommodityRepository.deleteActivityCommodityCatalog(reqBO);
        this.dycActActivityCommodityRepository.deleteActivityCommodity(reqBO);
        this.dycActActivityUserRepository.deleteActivityUser(reqBO);
        return i;
    }

    @Override
    public DycActivityBaseInfo copyActivity(DycActivityDO reqBO) {
        DycSaasActQueryActivityUserPageListRspBO userInfoBasePageRspBo;
        BasePageRspBo<DycActivitySupplierInfo> supplierInfoBasePageRspBo;
        DycActivityDO activityDO = new DycActivityDO();
        activityDO.setActivityId(reqBO.getActivityId());
        List<DycActivityBaseInfo> baseInfos = this.dycActActivityRepository.queryActivityList(activityDO);
        if (1 != baseInfos.size()) {
            throw new ZTBusinessException("\u5f53\u524d\u6d3b\u52a8id\uff0c\u5b58\u5728\u591a\u6761\u6d3b\u52a8\uff01");
        }
        DycActivityDO aDo = new DycActivityDO();
        aDo.setObjId(reqBO.getActivityId());
        aDo.setObjType(1);
        List<DycActivityFileInfo> fileInfos = this.dycActFileRepository.queryActivityFileList(aDo);
        DycActiveBaseInfoSaveReqBO infoSaveReqBO = (DycActiveBaseInfoSaveReqBO)JSON.parseObject((String)JSON.toJSONString((Object)baseInfos.get(0)), DycActiveBaseInfoSaveReqBO.class);
        infoSaveReqBO.setFileInfoBOS(fileInfos);
        infoSaveReqBO.setCreateUserId(reqBO.getCreateUserId());
        infoSaveReqBO.setCreateUserName(reqBO.getCreateUserName());
        infoSaveReqBO.setActivityId(null);
        DycActivityBaseInfo dycActivityBaseInfo = this.saveActiveBaseInfo(infoSaveReqBO);
        BasePageRspBo<DycActActivityRelaCommodityInfo> infoBasePageRspBo = this.dycActActivityCommodityRepository.queryActivityCommodityPageList(activityDO);
        if (infoBasePageRspBo.getRows().size() > 0) {
            DycActivityDO commodityDo = new DycActivityDO();
            commodityDo.setActActivityRelaCommodityBOS(infoBasePageRspBo.getRows());
            commodityDo.setActivityId(dycActivityBaseInfo.getActivityId());
            commodityDo.setCreateUserId(reqBO.getCreateUserId());
            commodityDo.setCreateUserName(reqBO.getCreateUserName());
            this.dycActActivityCommodityRepository.batchSelectActivityCommodity(commodityDo);
        }
        DycQueryActivityCommodityPoolPageListReqBO poolPageListReqBO = new DycQueryActivityCommodityPoolPageListReqBO();
        poolPageListReqBO.setActivityId(reqBO.getActivityId());
        BasePageRspBo<DycActivityCommodityPoolInfo> poolInfoBasePageRspBo = this.dycActActivityCommodityRepository.queryActivityCommodityPoolPageList(poolPageListReqBO);
        if (poolInfoBasePageRspBo.getRows().size() > 0) {
            DycActivityDO commodityDo = new DycActivityDO();
            commodityDo.setActivityCommodityPoolInfos(poolInfoBasePageRspBo.getRows());
            commodityDo.setActivityId(dycActivityBaseInfo.getActivityId());
            commodityDo.setCreateUserId(reqBO.getCreateUserId());
            commodityDo.setCreateUserName(reqBO.getCreateUserName());
            this.dycActActivityCommodityRepository.batchSelectActivityCommodityPool(commodityDo);
        }
        DycActiveCommodityCatalogQueryBO catalogQueryBO = new DycActiveCommodityCatalogQueryBO();
        catalogQueryBO.setActivityId(reqBO.getActivityId());
        BasePageRspBo<DycActiveCommodityCatalogInfo> catalogInfoBasePageRspBo = this.dycActActivityCommodityRepository.queryActiveCommodityCatalogList(catalogQueryBO);
        if (catalogInfoBasePageRspBo.getRows().size() > 0) {
            DycActivityDO commodityDo = new DycActivityDO();
            commodityDo.setCommodityCatalogInfoBOS(catalogInfoBasePageRspBo.getRows());
            commodityDo.setActivityId(dycActivityBaseInfo.getActivityId());
            commodityDo.setCreateUserId(reqBO.getCreateUserId());
            commodityDo.setCreateUserName(reqBO.getCreateUserName());
            this.dycActActivityCommodityRepository.batchSelectActivityCommodityCatalog(commodityDo);
        }
        if ((supplierInfoBasePageRspBo = this.dycActActivitySupplierRepository.queryActiveSupplierList(activityDO)).getRows().size() > 0) {
            DycActivitySupplierInfoAddBatchBO infoAddBatchBO = new DycActivitySupplierInfoAddBatchBO();
            infoAddBatchBO.setActivityId(dycActivityBaseInfo.getActivityId());
            infoAddBatchBO.setSupplierList(supplierInfoBasePageRspBo.getRows());
            this.dycActActivitySupplierRepository.addBatchActiveSupplier(infoAddBatchBO);
        }
        if ((userInfoBasePageRspBo = this.dycActActivityUserRepository.queryActivityUserPageList(activityDO)).getRows().size() > 0) {
            DycActivityDO userDO = new DycActivityDO();
            userDO.setCreateUserName(reqBO.getCreateUserName());
            userDO.setCreateUserId(reqBO.getCreateUserId());
            userDO.setActivityId(reqBO.getActivityId());
            userDO.setActivityUserList(userInfoBasePageRspBo.getRows());
            this.dycActActivityUserRepository.batchSelectActivityUser(userDO);
        }
        return dycActivityBaseInfo;
    }

    @Override
    public DycActivityUserInfo batchSelectActivityUser(DycActivityDO reqBO) {
        DycActivityDO activityDO = new DycActivityDO();
        activityDO.setActivityId(reqBO.getActivityId());
        List<DycActivityUserInfo> infos = this.dycActActivityUserRepository.queryActivityUserList(activityDO);
        Map<String, DycActivityUserInfo> userInfoMap = infos.stream().collect(Collectors.toMap(DycActivityUserInfo::getActUserName, item -> item));
        reqBO.getActivityUserList().forEach(item -> {
            if (!ObjectUtils.isEmpty(userInfoMap.get(item.getActUserName()))) {
                throw new ZTBusinessException("\u9009\u62e9\u7684\u7528\u6237\uff0c\u5728\u5df2\u9009\u5217\u8868\u4e2d\u5b58\u5728\uff01");
            }
        });
        DycActivityUserInfo rspBO = this.dycActActivityUserRepository.batchSelectActivityUser(reqBO);
        int countUser = this.dycActActivityUserRepository.selectCountUser(reqBO);
        DycActivityDO aDo = new DycActivityDO();
        aDo.setActivityId(reqBO.getActivityId());
        aDo.setTotalUser(countUser);
        this.dycActActivityRepository.updateActivityState(aDo);
        return rspBO;
    }

    @Override
    public DycActivityUserInfo batchRemoveActivityUser(DycActivityDO reqBO) {
        DycActivityUserInfo rspBO = this.dycActActivityUserRepository.batchRemoveActivityUser(reqBO);
        int countUser = this.dycActActivityUserRepository.selectCountUser(reqBO);
        BigDecimal decimal = this.dycActActivityUserRepository.selectCountUserScores(reqBO);
        DycActivityDO aDo = new DycActivityDO();
        aDo.setActivityId(reqBO.getActivityId());
        aDo.setTotalUser(countUser);
        aDo.setTotalScores(decimal);
        this.dycActActivityRepository.updateActivityState(aDo);
        return rspBO;
    }

    @Override
    public DycActivityUserInfo modifyActivityUserScores(DycActivityDO reqBO) {
        DycActivityUserInfo rspBO = this.dycActActivityUserRepository.modifyActivityUserScores(reqBO);
        BigDecimal decimal = this.dycActActivityUserRepository.selectCountUserScores(reqBO);
        DycActivityDO aDo = new DycActivityDO();
        aDo.setActivityId(reqBO.getActivityId());
        aDo.setTotalScores(decimal);
        this.dycActActivityRepository.updateActivityState(aDo);
        return rspBO;
    }

    @Override
    public DycActImportActivityUserModelRspBO importActivityUser(DycActImportActivityUserModelReqBO reqBO) {
        DycActivityUserInfo userInfo;
        DycActImportActivityUserModelRspBO rspBO = new DycActImportActivityUserModelRspBO();
        if (CollectionUtils.isEmpty(reqBO.getUserInfoList())) {
            throw new ZTBusinessException("\u6ca1\u6709\u9700\u8981\u589e\u52a0\u7684\u7528\u6237");
        }
        if (reqBO.getActivityId() == null) {
            throw new ZTBusinessException("\u6d3b\u52a8id\u4e3a\u7a7a");
        }
        DycActivityBaseInfo dycActivityBaseInfo = new DycActivityBaseInfo();
        dycActivityBaseInfo.setActivityId(reqBO.getActivityId());
        dycActivityBaseInfo.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        DycActivityBaseInfo modelByNew = this.dycActActivityRepository.getModelByNew(dycActivityBaseInfo);
        if (modelByNew == null || modelByNew.getActivityId() == null) {
            throw new ZTBusinessException("\u8be5\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        List<String> userNameList = reqBO.getUserInfoList().stream().map(DycActActivityUserInfoBO::getActUserName).collect(Collectors.toList());
        DycActivityDO dycActivityDO = new DycActivityDO();
        dycActivityDO.setActivityId(reqBO.getActivityId());
        dycActivityDO.setUserNameList(userNameList);
        List<DycActivityUserInfo> dycActivityUserInfos = this.dycActActivityUserRepository.queryActivityUserList(dycActivityDO);
        Map<Object, Object> collect = new HashMap();
        int userNum = 0;
        BigDecimal totalScores = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(dycActivityUserInfos)) {
            userNum = dycActivityUserInfos.size();
            collect = dycActivityUserInfos.stream().collect(Collectors.toMap(DycActivityUserInfo::getActUserName, o -> o));
        }
        ArrayList<DycActivityUserInfo> addList = new ArrayList<DycActivityUserInfo>();
        ArrayList<Long> delIdList = new ArrayList<Long>();
        for (DycActActivityUserInfoBO infoBO : reqBO.getUserInfoList()) {
            if (!collect.isEmpty() && collect.containsKey(infoBO.getActUserName())) {
                DycActivityUserInfo activityUserInfo = (DycActivityUserInfo)collect.get(infoBO.getActUserName());
                DycActivityUserInfo dycActivityUserInfo = this.getUserInfo(infoBO, reqBO);
                dycActivityUserInfo.setUpdateTime(new Date());
                dycActivityUserInfo.setUpdateUserId(reqBO.getUserId());
                dycActivityUserInfo.setUpdateUserName(reqBO.getName());
                dycActivityUserInfo.setCreateUserId(activityUserInfo.getCreateUserId());
                dycActivityUserInfo.setCreateUserName(activityUserInfo.getCreateUserName());
                dycActivityUserInfo.setCreateTime(activityUserInfo.getCreateTime());
                delIdList.add(activityUserInfo.getId());
                addList.add(dycActivityUserInfo);
                ((DycActivityUserInfo)collect.get(infoBO.getActUserName())).setGiveScores(infoBO.getGiveScores());
                totalScores = totalScores.add(infoBO.getGiveScores().subtract(activityUserInfo.getGiveScores()));
                continue;
            }
            DycActivityUserInfo dycActivityUserInfo = this.getUserInfo(infoBO, reqBO);
            dycActivityUserInfo.setCreateUserId(reqBO.getUserId());
            dycActivityUserInfo.setCreateTime(new Date());
            dycActivityUserInfo.setCreateUserName(reqBO.getName());
            addList.add(dycActivityUserInfo);
            totalScores = totalScores.add(infoBO.getGiveScores());
            ++userNum;
        }
        if (!CollectionUtils.isEmpty(addList)) {
            if (!CollectionUtils.isEmpty(delIdList)) {
                userInfo = new DycActivityUserInfo();
                userInfo.setIds(delIdList);
                this.dycActActivityUserRepository.delete(userInfo);
            }
            this.dycActActivityUserRepository.insertBatchNew(addList);
        }
        userInfo = new DycActivityUserInfo();
        userInfo.setActivityId(reqBO.getActivityId());
        userNum = this.dycActActivityUserRepository.count(userInfo);
        totalScores = this.dycActActivityUserRepository.sumScores(userInfo);
        DycActivityBaseInfo set = new DycActivityBaseInfo();
        set.setUpdateTime(new Date());
        set.setUpdateUserId(reqBO.getUserId());
        set.setUpdateUserName(reqBO.getName());
        set.setTotalUser(userNum);
        set.setTotalScores(totalScores);
        DycActivityBaseInfo where = new DycActivityBaseInfo();
        where.setActivityId(reqBO.getActivityId());
        this.dycActActivityRepository.updateByNew(set, where);
        return rspBO;
    }

    private DycActivityUserInfo getUserInfo(DycActActivityUserInfoBO infoBO, DycActImportActivityUserModelReqBO reqBO) {
        DycActivityUserInfo dycActivityUserInfo = new DycActivityUserInfo();
        dycActivityUserInfo.setId(Sequence.getInstance().nextId());
        dycActivityUserInfo.setActivityId(reqBO.getActivityId());
        dycActivityUserInfo.setUserName(infoBO.getActUserName());
        dycActivityUserInfo.setName(infoBO.getActName());
        dycActivityUserInfo.setWorkNo(infoBO.getActWorkNo());
        dycActivityUserInfo.setWorkNo(infoBO.getActWorkNo());
        dycActivityUserInfo.setSex(infoBO.getSex());
        dycActivityUserInfo.setPhone(infoBO.getPhone());
        dycActivityUserInfo.setUserOrgId(infoBO.getActUserOrgId());
        dycActivityUserInfo.setUserOrgName(infoBO.getActUserOrgName());
        dycActivityUserInfo.setUserCompanyId(infoBO.getActUserCompanyId());
        dycActivityUserInfo.setUserCompanyName(infoBO.getActUserCompanyName());
        dycActivityUserInfo.setUserOrgPath(infoBO.getActUserOrgPath());
        dycActivityUserInfo.setScoresType(infoBO.getScoresType());
        dycActivityUserInfo.setGiveScores(infoBO.getGiveScores());
        dycActivityUserInfo.setBalanceScores(infoBO.getBalanceScores());
        dycActivityUserInfo.setUsedScores(infoBO.getUsedScores());
        dycActivityUserInfo.setUserId(infoBO.getActUserId());
        dycActivityUserInfo.setDelFlag(0);
        return dycActivityUserInfo;
    }

    private Boolean checkSku(List<DycActImportActivityInfoModelBO> list, DycActImportActivityCommodityInfo info, ActSkuInfoBO skuInfoBO) {
        if (skuInfoBO == null) {
            list.add(this.setFailImport("\u672a\u627e\u5230\u5546\u54c1", info.getGluttonLineNum()));
            return true;
        }
        if (!DycActivityConstants.SkuStatue.ON_SALE.equals(skuInfoBO.getSkuStatus())) {
            list.add(this.setFailImport("\u5546\u54c1\u72b6\u6001\u4e0d\u4e3a\u5df2\u4e0a\u67b6", info.getGluttonLineNum()));
            return true;
        }
        if (!DycActivityConstants.CatalogStatus.ENABLE.equals(skuInfoBO.getCatalogId1Status())) {
            list.add(this.setFailImport("\u5546\u54c1\u4e00\u7ea7\u7c7b\u76ee\u5df2\u505c\u7528", info.getGluttonLineNum()));
            return true;
        }
        if (!DycActivityConstants.CatalogStatus.ENABLE.equals(skuInfoBO.getCatalogId2Status())) {
            list.add(this.setFailImport("\u5546\u54c1\u4e8c\u7ea7\u7c7b\u76ee\u5df2\u505c\u7528", info.getGluttonLineNum()));
            return true;
        }
        if (!DycActivityConstants.CatalogStatus.ENABLE.equals(skuInfoBO.getCatalogId3Status())) {
            list.add(this.setFailImport("\u5546\u54c1\u4e09\u7ea7\u7ea7\u7c7b\u76ee\u5df2\u505c\u7528", info.getGluttonLineNum()));
            return true;
        }
        if (DycActivityConstants.IsAnomalousPrice.ABNORMAL.equals(skuInfoBO.getIsAnomalousPrice())) {
            list.add(this.setFailImport("\u5546\u54c1\u4ef7\u683c\u5f02\u5e38", info.getGluttonLineNum()));
            return true;
        }
        return false;
    }

    private DycActImportActivityInfoModelBO setFailImport(String string, Long lineNum) {
        DycActImportActivityInfoModelBO dycActImportActivityInfoModelBO = new DycActImportActivityInfoModelBO();
        dycActImportActivityInfoModelBO.setFailReason("\u7b2c" + lineNum + "\u884c" + string);
        dycActImportActivityInfoModelBO.setLineNum(lineNum);
        return dycActImportActivityInfoModelBO;
    }

    private DycActActivityRelaCommodityInfo setCommodityInfo(ActSkuInfoBO skuInfoBO) {
        DycActActivityRelaCommodityInfo commodityInfo = new DycActActivityRelaCommodityInfo();
        commodityInfo.setRelaId(Sequence.getInstance().nextId());
        commodityInfo.setDelFlag(0);
        commodityInfo.setSkuId(skuInfoBO.getSkuId());
        commodityInfo.setCommodityPoolName(skuInfoBO.getPoolNames());
        commodityInfo.setSkuCode(skuInfoBO.getExtSkuId());
        commodityInfo.setSkuName(skuInfoBO.getSkuName());
        commodityInfo.setSkuUrl(skuInfoBO.getSkuUrl());
        commodityInfo.setSkuStatus(skuInfoBO.getSkuStatus());
        commodityInfo.setFirstCatalogId(String.valueOf(skuInfoBO.getCatalogId1()));
        commodityInfo.setFirstCatalogName(skuInfoBO.getCatalogName1());
        commodityInfo.setSecondCatalogId(String.valueOf(skuInfoBO.getCatalogId2()));
        commodityInfo.setSecondCatalogName(skuInfoBO.getCatalogName2());
        commodityInfo.setThreeCatalogId(String.valueOf(skuInfoBO.getCatalogId3()));
        commodityInfo.setThreeCatalogName(skuInfoBO.getCatalogName3());
        commodityInfo.setCterminalUrl(skuInfoBO.getJdSkuUrl());
        commodityInfo.setBrand(skuInfoBO.getBrandName());
        commodityInfo.setPrice(skuInfoBO.getAgreementPrice());
        if (skuInfoBO.getGoodRate() != null) {
            commodityInfo.setFavorableRate(skuInfoBO.getGoodRate().doubleValue());
        }
        return commodityInfo;
    }

    @Override
    public DycActImportActivityCommodityModelRspBO importActivityCommodity(DycActImportActivityCommodityModelReqBO reqBO) {
        DycActImportActivityCommodityModelRspBO rspBO = new DycActImportActivityCommodityModelRspBO();
        ArrayList<DycActImportActivityInfoModelBO> list = new ArrayList<DycActImportActivityInfoModelBO>();
        if (ObjectUtils.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e3a\u7a7a");
        }
        Long activityId = reqBO.getActivityId();
        Long userId = reqBO.getUserId();
        String name = reqBO.getName();
        if (activityId == null || userId == null || StringUtils.isEmpty((CharSequence)name)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBO.getCommodityItem())) {
            throw new ZTBusinessException("\u6ca1\u6709\u9700\u8981\u589e\u52a0\u7684\u5546\u54c1");
        }
        DycActivityBaseInfo dycActivityBaseInfo = new DycActivityBaseInfo();
        dycActivityBaseInfo.setActivityId(activityId);
        dycActivityBaseInfo.setDelFlag(ActConstants.DelFlag.NOT_DEL);
        DycActivityBaseInfo modelByNew = this.dycActActivityRepository.getModelByNew(dycActivityBaseInfo);
        if (modelByNew == null || modelByNew.getActivityId() == null) {
            throw new ZTBusinessException("\u8be5\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        List<String> extSkuIds = reqBO.getCommodityItem().stream().map(DycActImportActivityCommodityInfo::getSkuCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        DycActivityDO dycActivityDO = new DycActivityDO();
        dycActivityDO.setActivityId((long)activityId);
        dycActivityDO.setSkuCodeList(extSkuIds);
        dycActivityDO.setCommodityRelaMethod(Integer.valueOf("3"));
        List<DycActActivityRelaCommodityInfo> commodityInfos = this.dycActActivityCommodityRepository.queryActivityCommodityList(dycActivityDO);
        Map<String, DycActActivityRelaCommodityInfo> collect = commodityInfos.stream().collect(Collectors.toMap(DycActActivityRelaCommodityInfo::getSkuCode, v -> v));
        if (CollectionUtils.isEmpty(extSkuIds)) {
            for (DycActImportActivityCommodityInfo info : reqBO.getCommodityItem()) {
                list.add(this.setFailImport("\u5546\u54c1\u7f16\u7801\u5fc5\u586b", info.getGluttonLineNum()));
            }
            rspBO.setFailReasonList(list);
            return rspBO;
        }
        Map<String, ActSkuInfoBO> infoBOMap = this.dycActSkuInfoRepository.queryActSkuInfoByCodeList(extSkuIds);
        DycActivityDO dycActivityInfo = new DycActivityDO();
        dycActivityInfo.setActivityId((long)activityId);
        dycActivityInfo.setCreateUserId((long)userId);
        dycActivityInfo.setCreateUserName(name);
        ArrayList<DycActActivityRelaCommodityInfo> actActivityRelaCommodityBOS = new ArrayList();
        ArrayList<Long> delIdList = new ArrayList<Long>();
        for (DycActImportActivityCommodityInfo o : reqBO.getCommodityItem()) {
            if (StringUtils.isBlank((CharSequence)o.getSkuCode())) {
                list.add(this.setFailImport("\u5546\u54c1\u7f16\u7801\u5fc5\u586b", o.getGluttonLineNum()));
                continue;
            }
            ActSkuInfoBO skuInfoBO = infoBOMap.get(o.getSkuCode());
            if (this.checkSku(list, o, skuInfoBO).booleanValue()) continue;
            DycActActivityRelaCommodityInfo commodityInfo = this.setCommodityInfo(skuInfoBO);
            if (collect.size() > 0 && collect.containsKey(o.getSkuCode())) {
                DycActActivityRelaCommodityInfo dycActActivityRelaCommodityInfo = collect.get(o.getSkuCode());
                commodityInfo.setActivityId((long)activityId);
                commodityInfo.setUpdateTime(new Date());
                commodityInfo.setUpdateUserName(name);
                commodityInfo.setUpdateUserId((long)userId);
                commodityInfo.setCreateTime(dycActActivityRelaCommodityInfo.getCreateTime());
                commodityInfo.setCreateUserName(dycActActivityRelaCommodityInfo.getCreateUserName());
                commodityInfo.setCreateUserId(dycActActivityRelaCommodityInfo.getCreateUserId());
                actActivityRelaCommodityBOS.add(commodityInfo);
                delIdList.add(dycActActivityRelaCommodityInfo.getRelaId());
                continue;
            }
            commodityInfo.setCreateTime(new Date());
            commodityInfo.setCreateUserName(reqBO.getName());
            commodityInfo.setCreateUserId(reqBO.getUserId());
            commodityInfo.setActivityId((long)activityId);
            actActivityRelaCommodityBOS.add(commodityInfo);
        }
        if (!CollectionUtils.isEmpty(actActivityRelaCommodityBOS)) {
            int totalCommodity = actActivityRelaCommodityBOS.size();
            if (modelByNew.getTotalCommodity() != null) {
                totalCommodity += modelByNew.getTotalCommodity().intValue();
            }
            if (!CollectionUtils.isEmpty(delIdList)) {
                totalCommodity -= delIdList.size();
                DycActivityCommodityPoolInfo dycActivityCommodityPoolInfo = new DycActivityCommodityPoolInfo();
                dycActivityCommodityPoolInfo.setRelaIdList(delIdList);
                this.dycActActivityCommodityRepository.delete(dycActivityCommodityPoolInfo);
            }
            actActivityRelaCommodityBOS = actActivityRelaCommodityBOS.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DycActActivityRelaCommodityInfo>(Comparator.comparing(DycActActivityRelaCommodityInfo::getSkuCode))), ArrayList::new));
            this.dycActActivityCommodityRepository.insertAllCommodity(actActivityRelaCommodityBOS);
            DycActActivityRelaCommodityInfo dycActActivityRelaCommodityInfo = new DycActActivityRelaCommodityInfo();
            dycActActivityRelaCommodityInfo.setActivityId(reqBO.getActivityId());
            totalCommodity = this.dycActActivityCommodityRepository.count(dycActActivityRelaCommodityInfo);
            DycActivityBaseInfo set = new DycActivityBaseInfo();
            set.setTotalCommodity(totalCommodity);
            set.setUpdateTime(new Date());
            set.setUpdateUserId(userId);
            set.setUpdateUserName(name);
            DycActivityBaseInfo where = new DycActivityBaseInfo();
            where.setActivityId(activityId);
            this.dycActActivityRepository.updateByNew(set, where);
        }
        rspBO.setFailReasonList(list);
        return rspBO;
    }

    @Override
    public List<Long> autoEffectActivity(DycActivityDO reqBO) {
        return this.dycActActivityRepository.autoEffectActivity(reqBO);
    }

    @Override
    public DycActivityBaseInfo autoLoseEffectActivity(DycActivityDO reqBO) {
        return this.dycActActivityRepository.autoLoseEffectActivity(reqBO);
    }

    @Override
    public BasePageRspBo<DycActivityUserScoresUseRecordInfo> queryActivityUserScoresUseRecordPageList(DycActivityDO reqBO) {
        return this.dycActActivityUserRepository.queryActivityUserScoresUseRecordPageList(reqBO);
    }

    @Override
    public int deductOrReturnActivityScores(DycActivityDO reqBO) {
        return this.dycActActivityUserRepository.deductOrReturnActivityScores(reqBO);
    }

    @Override
    public List<DycActSceneInfo> queryActivityScene(DycActSceneInfoDO reqBO) {
        return this.dycActConfigRepository.queryActivityScene(reqBO);
    }

    @Override
    public int updateActivityState(DycActivityDO reqBO) {
        return this.dycActActivityRepository.updateActivityState(reqBO);
    }

    @Override
    public List<DycActivitySupplierInfo> queryActivitySelectableSupplierList(DycActivityDO reqBO) {
        return this.dycActActivitySupplierRepository.queryActiveSupplierAllList(reqBO);
    }

    @Override
    public DycActivityFileInfo saveActFileInfo(DycActivityFileInfo reqBO) {
        return this.dycActFileRepository.saveActivityFileInfo(reqBO);
    }

    @Override
    public int deleteActFileInfo(DycActivityFileInfo reqBO) {
        return this.dycActFileRepository.deleteActivityFileInfo(reqBO);
    }

    @Override
    public DycActivityFileInfo qryActFileInfo(DycActivityFileInfo reqBO) {
        return this.dycActFileRepository.queryActivityFile(reqBO);
    }

    @Override
    public int quoteActivityCommodity(DycActivityDO reqBO) {
        DycActivityDO activityDO = new DycActivityDO();
        activityDO.setActivityId(reqBO.getQuoteActivityId());
        activityDO.setIsAnomalousPrice(1);
        List<DycActActivityRelaCommodityInfo> commodityInfos = this.dycActActivityCommodityRepository.selectByOnShelf(activityDO);
        DycActivityDO dycActivityDO = new DycActivityDO();
        dycActivityDO.setActivityId(reqBO.getActivityId());
        dycActivityDO.setCommodityRelaMethod(3);
        List<DycActActivityRelaCommodityInfo> relaCommodityInfos = this.dycActActivityCommodityRepository.queryActivityCommodityList(dycActivityDO);
        Set idSet = relaCommodityInfos.stream().map(DycActActivityRelaCommodityInfo::getSkuId).collect(Collectors.toSet());
        List<DycActActivityRelaCommodityInfo> filter = commodityInfos.stream().filter(item -> !idSet.contains(item.getSkuId())).collect(Collectors.toList());
        reqBO.setActActivityRelaCommodityBOS(filter);
        this.dycActActivityCommodityRepository.batchSelectActivityCommodity(reqBO);
        int countCommodity = this.dycActActivityCommodityRepository.selectCountCommodity(reqBO);
        DycActivityDO aDo = new DycActivityDO();
        aDo.setActivityId(reqBO.getActivityId());
        aDo.setTotalCommodity(countCommodity);
        this.dycActActivityRepository.updateActivityState(aDo);
        return 0;
    }

    @Override
    public List<DycActActivityInfo> qryActInfoByUserId(DycActQryActInfoByUserQryDO reqBO) {
        return this.dycActActivityUserRepository.qryActInfoByUserId(reqBO);
    }

    @Override
    public int addBatchActivitySyncExternalRecord(List<ActActivitySyncExternalRecordDO> reqBO) {
        return this.dycActActivitySyncExternalRecordRepository.addBatchActivitySyncExternalRecord(reqBO);
    }

    @Override
    public ActActivitySyncExternalRecordInfo updateActivitySyncExternalRecord(ActActivitySyncExternalRecordDO reqBO) {
        return this.dycActActivitySyncExternalRecordRepository.updateActivitySyncExternalRecord(reqBO);
    }

    @Override
    public ActActivitySyncExternalRecordInfo queryActivitySyncExternalRecordSingle(ActActivitySyncExternalRecordDO reqBO) {
        return this.dycActActivitySyncExternalRecordRepository.queryActivitySyncExternalRecordSingle(reqBO);
    }

    @Override
    public List<ActActivitySyncExternalRecordInfo> queryActivitySyncExternalRecordList(ActActivitySyncExternalRecordDO reqBO) {
        return this.dycActActivitySyncExternalRecordRepository.queryActivitySyncExternalRecordList(reqBO);
    }

    @Override
    public List<DycActivityUserInfo> queryActivityUserList(DycActivityDO reqBO) {
        return this.dycActActivityUserRepository.queryActivityUserList(reqBO);
    }

    @Override
    public List<DycActivityUserInfo> queryActivityUserNotInPoolList(DycActivityDO reqBO) {
        return this.dycActActivityUserRepository.queryActivityUserNotInPoolList(reqBO);
    }

    @Override
    public List<DycActivityUserInfo> queryActivityUserNotInUserMapList(DycActivityDO reqBO) {
        return this.dycActActivityUserRepository.queryActivityUserNotInUserMapList(reqBO);
    }

    @Override
    public DycActUserScoresBaseInfoRspBO queryUserScoresPageList(DycActUserScoresBaseInfoQueryBO reqBO) {
        return this.dycActActivityUserRepository.queryUserScoresPageList(reqBO);
    }

    @Override
    public DycActivityBaseInfo getActivityBaseInfoDetail(DycActivityDO dycActivityDO) {
        return this.dycActActivityRepository.getActivityBaseInfoDetail(dycActivityDO);
    }

    @Override
    public int updateCommodityState(DycActivityDO reqBO) {
        return this.dycActActivityCommodityRepository.updateCommodityState(reqBO);
    }

    @Override
    public int delEmptyActivityCommodityCatalog(DycActiveCommodityCatalogInfo reqBo) {
        DycActivityDO activityDO;
        int i = this.dycActActivityCommodityRepository.updateActiveCommodityCatalogInfoBy(reqBo);
        if (i > 0) {
            activityDO = new DycActivityDO();
            activityDO.setActivityId(reqBo.getActivityId());
            activityDO.setTotalCatalog(0);
            this.dycActActivityRepository.updateActivityState(activityDO);
        }
        activityDO = new DycActivityDO();
        activityDO.setActivityId(reqBo.getActivityId());
        this.dycActActivityCommodityCatalogInComRepository.delete(activityDO);
        return i;
    }

    @Override
    public int updateActivityUserInfoBy(DycActivityUserInfo setBo, DycActivityUserInfo whereBo) {
        return this.dycActActivityUserRepository.updateByNew(setBo, whereBo);
    }

    @Override
    public DycActivityUserInfo batchModifyActivityUserScores(DycActivityDO reqBO) {
        DycActivityUserInfo rspBO = this.dycActActivityUserRepository.batchModifyActivityUserScores(reqBO);
        BigDecimal decimal = this.dycActActivityUserRepository.selectCountUserScores(reqBO);
        DycActivityDO aDo = new DycActivityDO();
        aDo.setActivityId(reqBO.getActivityId());
        aDo.setTotalScores(decimal);
        this.dycActActivityRepository.updateActivityState(aDo);
        return rspBO;
    }

    @Override
    public DycActCheckUserNotScoreRspBo qryCheckUserNotScore(DycActCheckUserNotScoreReqBo reqBo) {
        DycActCheckUserNotScoreRspBo dycActCheckUserNotScoreRspBo = new DycActCheckUserNotScoreRspBo();
        DycActivityUserInfo dycActivityUserInfo = new DycActivityUserInfo();
        dycActivityUserInfo.setActivityId(reqBo.getActivityId());
        int checkByNewByCheck = this.dycActActivityUserRepository.getCheckByNewByCheck(dycActivityUserInfo);
        if (checkByNewByCheck > 0) {
            dycActCheckUserNotScoreRspBo.setIsNot(Boolean.valueOf(true));
        } else {
            dycActCheckUserNotScoreRspBo.setIsNot(Boolean.valueOf(false));
        }
        return dycActCheckUserNotScoreRspBo;
    }

    @Override
    public BasePageRspBo<DycActUserScoresBaseInfo> qryActivityUserInfoPageList(DycActUserScoresBaseInfoQueryBO queryBO) {
        return this.dycActActivityUserRepository.qryActivityUserInfoPageList(queryBO);
    }

    @Override
    public int selectNotUsedScores(DycActivityDO reqBO) {
        return this.dycActActivityUserRepository.selectNotUsedScores(reqBO);
    }

    @Override
    public DycActivityUserInfo dealCreateScoreExceedsLimit(DycActivityDO reqBO) {
        return this.dycActActivityUserRepository.dealCreateScoreExceedsLimit(reqBO);
    }

    @Override
    public List<DycActivityBaseInfo> getWarningActivity(DycActivityBaseInfo reqBO) {
        return this.dycActActivityRepository.getWarningActivity(reqBO);
    }

    @Override
    public void dealActivityAlert(DycActDealOrderAlertDO dycActDealOrderAlertDO) {
        DycActivityBaseInfo set = new DycActivityBaseInfo();
        set.setAlertType(dycActDealOrderAlertDO.getAlertType());
        set.setWarningDay(dycActDealOrderAlertDO.getDays());
        DycActivityBaseInfo where = new DycActivityBaseInfo();
        where.setActivityId(Long.valueOf(dycActDealOrderAlertDO.getOrderId()));
        this.dycActActivityRepository.updateByNew(set, where);
        DycActFscOrderDO dycActFscOrderDO = new DycActFscOrderDO();
        dycActFscOrderDO.setFscOrderId(Long.parseLong(dycActDealOrderAlertDO.getOrderId()));
        dycActFscOrderDO.setOldAlertType(dycActDealOrderAlertDO.getAlertType());
        ActAlertOrderInfo actAlertOrderInfo = this.dycActAlertInfoRepository.getAlertInfo(dycActFscOrderDO);
        if (actAlertOrderInfo == null) {
            this.dycActAlertInfoRepository.saveAlertInfo(dycActDealOrderAlertDO);
        }
    }

    @Override
    public void updateActAlertType(DycActivityDO reqBO) {
        DycActivityBaseInfo dycActivityBaseInfo = new DycActivityBaseInfo();
        dycActivityBaseInfo.setActivityId(reqBO.getActivityId());
        this.dycActActivityRepository.updateAlertType(dycActivityBaseInfo);
        DycActDealOrderAlertDO set = new DycActDealOrderAlertDO();
        set.setAlertState(DycActivityConstants.AlertState.DEALED);
        set.setUpdateTime(new Date());
        DycActDealOrderAlertDO where = new DycActDealOrderAlertDO();
        where.setObjId(reqBO.getActivityId().toString());
        where.setAlertType(DycActivityConstants.AlertType.LAST_PAY);
        where.setAlertState(DycActivityConstants.AlertState.UN_DEAL);
        this.dycActAlertInfoRepository.updateAlert(set, where);
    }

    @Override
    public List<DycActivityDO> querySkuToActivity(DycActivityDO activityDO) {
        return this.dycActActivityRepository.querySkuToActivity(activityDO);
    }

    @Override
    public List<DycActivityChangeInfo> getListActivityId(DycActivityChangeInfo reqBo) {
        return this.dycActActivityChangeRepository.getListActivityId(reqBo);
    }

    @Override
    public int addActActivityCommodityCatalogSum(ActActivityCommodityCatalogSumDO reqBO) {
        return this.actActivityCommodityCatalogSumRepository.addActActivityCommodityCatalogSum(reqBO);
    }

    @Override
    public List<DycActiveCommodityCatalogInfo> queryActiveCommodityCatalogAllList(DycActiveCommodityCatalogQueryBO reqBO) {
        return this.dycActActivityCommodityRepository.queryActiveCommodityCatalogAllList(reqBO);
    }

    @Override
    public int updateActivityCommodityCatalogInCom(DycActivityDO reqBO) {
        return this.dycActActivityCommodityCatalogInComRepository.batchSelectActivityCommodity(reqBO);
    }

    @Override
    public List<DycActActivityRelaCommodityInfo> getListNew(DycActActivityRelaCommodityInfo reqBo) {
        return this.dycActActivityCommodityCatalogInComRepository.getListNew(reqBo);
    }

    @Override
    public DycActGuideDO querySelectCatalogTree(ActSelectQueryCatalogTreeReqBO reqBO) {
        DycActGuideDO rspBO = new DycActGuideDO();
        if (reqBO.getType() == 1) {
            DycActivityDO aDo = new DycActivityDO();
            aDo.setActivityId(reqBO.getObjId());
            DycActivityBaseInfo dycActivityBaseInfo = this.dycActActivityRepository.qryActiveBaseInfo(aDo);
            if (DycActivityConstants.ActivitySyncState.SUCCESS.equals(dycActivityBaseInfo.getActivitySyncState()) || DycActivityConstants.ActivitySyncState.PART_SUCCESS.equals(dycActivityBaseInfo.getActivitySyncState())) {
                rspBO = this.dycActActivityCommodityCatalogInComRepository.querySelectCatalogTree(reqBO);
            }
        } else if (reqBO.getType() == 2) {
            DycActivityChangeDO aDo = new DycActivityChangeDO();
            aDo.setChangeId(reqBO.getObjId());
            DycActivityChangeInfo dycActivityChangeInfo = this.dycActActivityChangeRepository.queryActivityChangeBaseInfo(aDo);
            if ("2".equals(dycActivityChangeInfo.getChangeState())) {
                rspBO = this.dycActActivityChangeCommodityCatalogInComRepository.querySelectCatalogTree(reqBO);
            }
        }
        return rspBO;
    }

    @Override
    public List<DycActActivityRelaCommodityInfo> getComCount(DycActivityDO reqBO) {
        return this.dycActActivityCommodityCatalogInComRepository.getComCount(reqBO);
    }

    @Override
    public ActNotifyDelayListRspBO queryActNotifyDelayList(ActNotifyDelayReqBO reqBO) {
        return this.actNotifyDelayRepository.queryActNotifyDelayList(reqBO);
    }

    @Override
    public int addActNotifyDelay(ActNotifyDelayReqBO reqBO) {
        return this.actNotifyDelayRepository.addActNotifyDelay(reqBO);
    }

    @Override
    public int deleteActNotifyDelay(ActNotifyDelayReqBO reqBO) {
        return this.actNotifyDelayRepository.deleteActNotifyDelay(reqBO);
    }
}

