/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.model.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.DycActSkuInfoModel;
import com.tydic.dyc.act.model.bo.ActActivitySkuChangePriceLogBO;
import com.tydic.dyc.act.model.bo.ActActivitySkuChangePriceLogListRspBO;
import com.tydic.dyc.act.model.bo.ActActivitySkuChangePriceLogReqBO;
import com.tydic.dyc.act.model.bo.ActJudgeGuideLowestPriceReqBO;
import com.tydic.dyc.act.model.bo.ActJudgeGuideLowestPriceRspBO;
import com.tydic.dyc.act.model.bo.ActRelSourcePoolBO;
import com.tydic.dyc.act.model.bo.ActRelSourcePoolReqBO;
import com.tydic.dyc.act.model.bo.ActSkuCheckInfoRspBO;
import com.tydic.dyc.act.model.bo.ActSkuDetailReqBO;
import com.tydic.dyc.act.model.bo.ActSkuDetailRspBO;
import com.tydic.dyc.act.model.bo.ActSkuGuideBO;
import com.tydic.dyc.act.model.bo.ActSkuGuideListRspBO;
import com.tydic.dyc.act.model.bo.ActSkuGuideReqBO;
import com.tydic.dyc.act.model.bo.ActSkuInfoDO;
import com.tydic.dyc.act.model.bo.ActSkuInfoListRspBO;
import com.tydic.dyc.act.model.bo.ActSkuInfoQryBO;
import com.tydic.dyc.act.model.bo.ActSkuInfoQryRspBO;
import com.tydic.dyc.act.model.bo.ActSkuInfoReqBO;
import com.tydic.dyc.act.model.bo.ActSkuInfoRspBO;
import com.tydic.dyc.act.model.bo.ActSkuPicListRspBO;
import com.tydic.dyc.act.model.bo.ActSkuPicReqBO;
import com.tydic.dyc.act.model.bo.ActSkuPriceLogListRspBO;
import com.tydic.dyc.act.model.bo.ActSkuPriceLogReqBO;
import com.tydic.dyc.act.model.bo.ActSkuSpecListRspBO;
import com.tydic.dyc.act.model.bo.ActSkuSpecReqBO;
import com.tydic.dyc.act.model.bo.ActSkuVendorReqBO;
import com.tydic.dyc.act.model.bo.ActSkuVendorRspBO;
import com.tydic.dyc.act.repository.api.DycActActivitySkuChangePriceLogRepository;
import com.tydic.dyc.act.repository.api.DycActRelSourcePoolRepository;
import com.tydic.dyc.act.repository.api.DycActSkuDetailRepository;
import com.tydic.dyc.act.repository.api.DycActSkuGuideRepository;
import com.tydic.dyc.act.repository.api.DycActSkuInfoRepository;
import com.tydic.dyc.act.repository.api.DycActSkuPicRepository;
import com.tydic.dyc.act.repository.api.DycActSkuPoolRepository;
import com.tydic.dyc.act.repository.api.DycActSkuPriceLogRepository;
import com.tydic.dyc.act.repository.api.DycActSkuSpecRepository;
import com.tydic.dyc.act.repository.api.DycActSkuVendorRepository;
import com.tydic.dyc.act.service.bo.DycActModifySkuCheckInfoReqBO;
import com.tydic.dyc.act.service.bo.DycActModifySkuCheckInfoRspBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPoolReqBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPoolRspBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPushInfoReqBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPushInfoRspBO;
import com.tydic.dyc.act.service.bo.DycActSkuPicCheckInfoReqBO;
import com.tydic.dyc.act.service.bo.DycActSkuPicCheckInfoRspBO;
import com.tydic.dyc.base.utils.JUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DycActSkuInfoModelImpl
implements DycActSkuInfoModel {
    @Autowired
    private DycActSkuInfoRepository dycActSkuInfoRepository;
    @Autowired
    private DycActSkuGuideRepository dycActSkuGuideRepository;
    @Autowired
    private DycActSkuDetailRepository dycActSkuDetailRepository;
    @Autowired
    private DycActSkuSpecRepository dycActSkuSpecRepository;
    @Autowired
    private DycActSkuPicRepository dycActSkuPicRepository;
    @Autowired
    private DycActSkuPriceLogRepository dycActSkuPriceLogRepository;
    @Autowired
    private DycActSkuVendorRepository dycActSkuVendorRepository;
    @Autowired
    private DycActSkuPoolRepository dycActSkuPoolRepository;
    @Autowired
    private DycActRelSourcePoolRepository dycActRelSourcePoolRepository;
    @Autowired
    private DycActActivitySkuChangePriceLogRepository dycActActivitySkuChangePriceLogRepository;

    @Override
    public ActSkuInfoQryRspBO querySkuPageList(ActSkuInfoQryBO qryBO) {
        this.reqAssemble(qryBO);
        ActSkuInfoQryRspBO infoQryRspBO = this.dycActSkuInfoRepository.querySkuPageList(qryBO);
        if (CollectionUtil.isEmpty((Collection)infoQryRspBO.getRows())) {
            return infoQryRspBO;
        }
        this.rspTranslate(infoQryRspBO);
        return infoQryRspBO;
    }

    @Override
    public ActSkuInfoQryRspBO querySkuPageListByLowestPrice(ActSkuInfoQryBO qryBO) {
        this.reqAssemble(qryBO);
        ActSkuInfoQryRspBO infoQryRspBO = this.dycActSkuInfoRepository.querySkuPageListByLowestPrice(qryBO);
        if (CollectionUtil.isEmpty((Collection)infoQryRspBO.getRows())) {
            return infoQryRspBO;
        }
        this.rspTranslate(infoQryRspBO);
        return infoQryRspBO;
    }

    private void setPoolRelReqQuery(Long poolId, ActSkuInfoQryBO qryBO, Integer relType) {
        DycActQuerySkuPoolReqBO skuPoolReqBO = new DycActQuerySkuPoolReqBO();
        skuPoolReqBO.setPoolId(poolId);
        DycActQuerySkuPoolRspBO skuPoolRspBO = this.dycActSkuPoolRepository.queryActSkuPoolSingle(skuPoolReqBO);
        if (ObjectUtil.isEmpty((Object)skuPoolRspBO)) {
            throw new ZTBusinessException("\u5546\u54c1\u6c60\u4e0d\u5b58\u5728");
        }
        ActRelSourcePoolReqBO relSourcePoolReqBO = new ActRelSourcePoolReqBO();
        relSourcePoolReqBO.setPoolId(poolId);
        List<ActRelSourcePoolBO> relSourcePoolBOS = this.dycActRelSourcePoolRepository.queryActRelSourcePoolList(relSourcePoolReqBO).getData();
        if (!CollectionUtil.isEmpty(relSourcePoolBOS)) {
            List<Long> sourceIds = relSourcePoolBOS.stream().map(ActRelSourcePoolBO::getSourceId).collect(Collectors.toList());
            if (DycActivityConstants.RelPoolOperType.REL.equals(relType)) {
                if (DycActivityConstants.PoolType.SUPPLIER.equals(skuPoolRspBO.getPoolType())) {
                    qryBO.setPoolSupplierIdList(sourceIds);
                    qryBO.setPoolId(null);
                } else if (DycActivityConstants.PoolType.CATALOG.equals(skuPoolRspBO.getPoolType())) {
                    qryBO.setPoolGuideIdList(sourceIds);
                    qryBO.setPoolId(null);
                }
            } else if (DycActivityConstants.PoolType.SUPPLIER.equals(skuPoolRspBO.getPoolType())) {
                qryBO.setExitsPoolSupplierIdList(sourceIds);
                qryBO.setExitsPoolId(null);
            } else if (DycActivityConstants.PoolType.CATALOG.equals(skuPoolRspBO.getPoolType())) {
                qryBO.setExitsPoolGuideIdList(sourceIds);
                qryBO.setExitsPoolId(null);
            }
        }
    }

    private List<Long> qryGuideIdList(Long guideCatalogId) {
        ActSkuGuideReqBO qrySubGuideBO = new ActSkuGuideReqBO();
        qrySubGuideBO.setUpperCatalogId(guideCatalogId);
        List<ActSkuGuideBO> list = this.queryActSkuGuideList(qrySubGuideBO).getData();
        if (!CollectionUtil.isEmpty(list)) {
            return list.stream().map(ActSkuGuideBO::getGuideCatalogId).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }

    private void reqAssemble(ActSkuInfoQryBO qryBO) {
        if (DycActivityConstants.CatalogLevel.THREE.equals(qryBO.getCatalogLevel())) {
            qryBO.setGuideId(qryBO.getGuideCatalogId());
        } else if (DycActivityConstants.CatalogLevel.TWO.equals(qryBO.getCatalogLevel())) {
            qryBO.setGuideIdList(this.qryGuideIdList(qryBO.getGuideCatalogId()));
        } else if (DycActivityConstants.CatalogLevel.ONE.equals(qryBO.getCatalogLevel())) {
            ArrayList<Long> threeGuideId = new ArrayList<Long>();
            List<Long> twoGuideId = this.qryGuideIdList(qryBO.getGuideCatalogId());
            if (!CollectionUtil.isEmpty(twoGuideId)) {
                for (Long guideId : twoGuideId) {
                    threeGuideId.addAll(this.qryGuideIdList(guideId));
                }
            }
            qryBO.setGuideIdList(threeGuideId);
        }
        if (ObjectUtil.isNotEmpty((Object)qryBO.getPoolId())) {
            this.setPoolRelReqQuery(qryBO.getPoolId(), qryBO, DycActivityConstants.RelPoolOperType.REL);
        }
        if (ObjectUtil.isNotEmpty((Object)qryBO.getExitsPoolId())) {
            this.setPoolRelReqQuery(qryBO.getPoolId(), qryBO, DycActivityConstants.RelPoolOperType.CANCEL_REL);
        }
    }

    private void rspTranslate(ActSkuInfoQryRspBO infoQryRspBO) {
        ActSkuGuideReqBO guideReqBO = new ActSkuGuideReqBO();
        guideReqBO.setGuideCatalogIdList(infoQryRspBO.getRows().stream().map(ActSkuInfoDO::getGuideId).collect(Collectors.toList()));
        Map<Long, ActSkuGuideBO> fullNameByCatalogIdMap = this.dycActSkuGuideRepository.getCatalogBOByCatalogIds(guideReqBO).getCatalogBOByCatalogIds();
        for (ActSkuInfoDO row : infoQryRspBO.getRows()) {
            if (DycActivityConstants.SkuStatue.ON_SALE.equals(row.getSkuStatus())) {
                row.setSkuStatusDesc("\u5df2\u4e0a\u67b6");
            } else if (DycActivityConstants.SkuStatue.WITHDRAWN.equals(row.getSkuStatus())) {
                row.setSkuStatusDesc("\u5df2\u4e0b\u67b6");
            } else if (DycActivityConstants.SkuStatue.DELETE.equals(row.getSkuStatus())) {
                row.setSkuStatusDesc("\u5df2\u5220\u9664");
            }
            if (DycActivityConstants.IsAnomalousPrice.ABNORMAL.equals(row.getIsAnomalousPrice())) {
                row.setIsAnomalousPriceStr("\u4ef7\u683c\u5f02\u5e38");
            } else if (DycActivityConstants.IsAnomalousPrice.NORMAL.equals(row.getIsAnomalousPrice())) {
                row.setIsAnomalousPriceStr("\u6838\u9a8c\u901a\u8fc7");
            }
            if (!fullNameByCatalogIdMap.containsKey(row.getGuideId())) continue;
            ActSkuGuideBO actSkuGuideBO = fullNameByCatalogIdMap.get(row.getGuideId());
            row.setFirstCatalogId(actSkuGuideBO.getFirstCatalogId());
            row.setFirstCatalogName(actSkuGuideBO.getFirstCatalogName());
            row.setSecondCatalogId(actSkuGuideBO.getSecondCatalogId());
            row.setSecondCatalogName(actSkuGuideBO.getSecondCatalogName());
            row.setThreeCatalogId(actSkuGuideBO.getThreeCatalogId());
            row.setThreeCatalogName(actSkuGuideBO.getThreeCatalogName());
            row.setThreeCatalogCode(actSkuGuideBO.getThreeCatalogCode());
            row.setCatalogNameDesc(actSkuGuideBO.getCatalogFullName());
        }
    }

    @Override
    public ActSkuGuideListRspBO queryActSkuGuideList(ActSkuGuideReqBO actSkuGuideReqBO) {
        return this.dycActSkuGuideRepository.queryActSkuGuideList(actSkuGuideReqBO);
    }

    @Override
    public ActSkuGuideListRspBO getCatalogBOByCatalogIds(ActSkuGuideReqBO actSkuGuideReqBO) {
        return this.dycActSkuGuideRepository.getCatalogBOByCatalogIds(actSkuGuideReqBO);
    }

    @Override
    public ActSkuInfoRspBO querySkuDetails(ActSkuInfoReqBO qryBO) {
        ActSkuInfoRspBO skuInfoRspBO = this.dycActSkuInfoRepository.queryActSkuInfoSingle(qryBO);
        if (ObjectUtil.isNotEmpty((Object)skuInfoRspBO.getData())) {
            ActSkuDetailReqBO detailReqBO = new ActSkuDetailReqBO();
            detailReqBO.setSkuId(skuInfoRspBO.getData().getSkuId());
            ActSkuDetailRspBO detailRspBO = this.dycActSkuDetailRepository.queryActSkuDetailSingle(detailReqBO);
            if (ObjectUtil.isNotEmpty((Object)detailRspBO.getData())) {
                skuInfoRspBO.getData().setSkuPcDetailUrl(detailRspBO.getData().getSkuPcDetailUrl());
            }
            ActSkuVendorReqBO vendorReqBO = new ActSkuVendorReqBO();
            vendorReqBO.setVendorId(skuInfoRspBO.getData().getSupplierId());
            ActSkuVendorRspBO vendorRspBO = this.dycActSkuVendorRepository.queryActSkuVendorSingle(vendorReqBO);
            if (ObjectUtil.isNotEmpty((Object)vendorRspBO.getData())) {
                skuInfoRspBO.getData().setSupplierCode(vendorRspBO.getData().getVendorCode());
                skuInfoRspBO.getData().setVenderCustNumber(vendorRspBO.getData().getVendorCustNumber());
                skuInfoRspBO.getData().setVenderContactUser(vendorRspBO.getData().getVendorContactUser());
                skuInfoRspBO.getData().setVenderContactPhone(vendorRspBO.getData().getVendorContactPhone());
            }
        }
        return skuInfoRspBO;
    }

    @Override
    public ActSkuSpecListRspBO queryActSkuSpecList(ActSkuSpecReqBO actSkuSpecReqBO) {
        return this.dycActSkuSpecRepository.queryActSkuSpecList(actSkuSpecReqBO);
    }

    @Override
    public ActSkuPicListRspBO queryActSkuPicList(ActSkuPicReqBO actSkuPicReqBO) {
        return this.dycActSkuPicRepository.queryActSkuPicList(actSkuPicReqBO);
    }

    @Override
    public ActSkuInfoListRspBO queryActSkuInfoList(ActSkuInfoReqBO actSkuInfoReqBO) {
        return this.dycActSkuInfoRepository.queryActSkuInfoList(actSkuInfoReqBO);
    }

    @Override
    public DycActQuerySkuPushInfoRspBO qrySkuPushInfo(DycActQuerySkuPushInfoReqBO reqBO) {
        ActSkuInfoQryRspBO actSkuInfoRspBO = this.dycActSkuInfoRepository.qrySkuPushInfo(reqBO.getSkuIds());
        return (DycActQuerySkuPushInfoRspBO)JUtil.js((Object)((Object)actSkuInfoRspBO), DycActQuerySkuPushInfoRspBO.class);
    }

    @Override
    public DycActSkuPicCheckInfoRspBO qryCheckSkuInfo(DycActSkuPicCheckInfoReqBO reqBO) {
        ActSkuCheckInfoRspBO actSkuInfoRspBO = this.dycActSkuInfoRepository.qryCheckSkuInfo(reqBO.getSkuIds());
        return (DycActSkuPicCheckInfoRspBO)JUtil.js((Object)((Object)actSkuInfoRspBO), DycActSkuPicCheckInfoRspBO.class);
    }

    @Override
    public DycActModifySkuCheckInfoRspBO modifySkuCheckInfo(DycActModifySkuCheckInfoReqBO reqBO) {
        ActSkuInfoRspBO rspBO = this.dycActSkuInfoRepository.modifySkuCheckInfo((ActSkuInfoReqBO)JUtil.js((Object)reqBO, ActSkuInfoReqBO.class));
        return (DycActModifySkuCheckInfoRspBO)JUtil.js((Object)rspBO, DycActModifySkuCheckInfoRspBO.class);
    }

    @Override
    public RspPage<ActActivitySkuChangePriceLogBO> queryActActivitySkuChangePriceLogListPage(ActActivitySkuChangePriceLogReqBO actActivitySkuChangePriceLogReqBO) {
        return this.dycActActivitySkuChangePriceLogRepository.queryActActivitySkuChangePriceLogListPageExt(actActivitySkuChangePriceLogReqBO);
    }

    @Override
    public ActActivitySkuChangePriceLogListRspBO addListActActivitySkuChangePriceLog(List<ActActivitySkuChangePriceLogReqBO> actActivitySkuChangePriceLogReqBO) {
        return this.dycActActivitySkuChangePriceLogRepository.addListActActivitySkuChangePriceLog(actActivitySkuChangePriceLogReqBO);
    }

    @Override
    public ActSkuPriceLogListRspBO qrySkuPriceLog(ActSkuPriceLogReqBO reqBO) {
        return this.dycActSkuPriceLogRepository.qrySkuPriceLog(reqBO);
    }

    @Override
    public ActJudgeGuideLowestPriceRspBO judgeGuideLowestPrice(ActJudgeGuideLowestPriceReqBO reqBO) {
        return this.dycActSkuInfoRepository.judgeGuideLowestPrice(reqBO);
    }

    @Override
    public ActJudgeGuideLowestPriceRspBO queryGuideToNumMap(ActJudgeGuideLowestPriceReqBO reqBO) {
        return this.dycActSkuInfoRepository.queryGuideToNumMap(reqBO);
    }
}

