/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.model.impl;

import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.model.api.DycActSkuPoolModel;
import com.tydic.dyc.act.model.bo.ActRelSkuPoolListRspBO;
import com.tydic.dyc.act.model.bo.ActRelSkuPoolReqBO;
import com.tydic.dyc.act.model.bo.ActRelSkuPoolRspBO;
import com.tydic.dyc.act.model.bo.ActRelSourcePoolBO;
import com.tydic.dyc.act.model.bo.ActRelSourcePoolListRspBO;
import com.tydic.dyc.act.model.bo.ActRelSourcePoolReqBO;
import com.tydic.dyc.act.model.bo.ActRelSourcePoolRspBO;
import com.tydic.dyc.act.model.bo.ActSkuGuideBO;
import com.tydic.dyc.act.model.bo.ActSkuGuideReqBO;
import com.tydic.dyc.act.model.bo.ActSkuPoolBO;
import com.tydic.dyc.act.model.bo.ActSkuPoolListRspBO;
import com.tydic.dyc.act.model.bo.ActSkuPoolReqBO;
import com.tydic.dyc.act.model.bo.ActSkuPoolRspBO;
import com.tydic.dyc.act.model.bo.ActSkuVendorBO;
import com.tydic.dyc.act.model.bo.ActSkuVendorReqBO;
import com.tydic.dyc.act.repository.api.DycActRelSkuPoolRepository;
import com.tydic.dyc.act.repository.api.DycActRelSourcePoolRepository;
import com.tydic.dyc.act.repository.api.DycActSkuGuideRepository;
import com.tydic.dyc.act.repository.api.DycActSkuPoolRepository;
import com.tydic.dyc.act.repository.api.DycActSkuVendorRepository;
import com.tydic.dyc.act.service.bo.DycActAddSkuPoolReqBO;
import com.tydic.dyc.act.service.bo.DycActAddSkuPoolRspBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPoolReqBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPoolRspBO;
import com.tydic.dyc.base.utils.JUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycActSkuPoolModelImpl
implements DycActSkuPoolModel {
    @Autowired
    private DycActSkuPoolRepository dycActSkuPoolRepository;
    @Autowired
    private DycActRelSkuPoolRepository dycActRelSkuPoolRepository;
    @Autowired
    private DycActRelSourcePoolRepository dycActRelSourcePoolRepository;
    @Autowired
    private DycActSkuVendorRepository dycActSkuVendorRepository;
    @Autowired
    private DycActSkuGuideRepository dycActSkuGuideRepository;

    @Override
    public DycActQuerySkuPoolRspBO querySkuPoolDetail(DycActQuerySkuPoolReqBO reqBO) {
        return this.dycActSkuPoolRepository.queryActSkuPoolSingle(reqBO);
    }

    @Override
    public DycActAddSkuPoolRspBO addSkuPool(DycActAddSkuPoolReqBO reqBO) {
        ActSkuPoolRspBO actSkuPoolRspBO = this.dycActSkuPoolRepository.addActSkuPool((ActSkuPoolReqBO)JUtil.js((Object)reqBO, ActSkuPoolReqBO.class));
        return (DycActAddSkuPoolRspBO)JUtil.js((Object)actSkuPoolRspBO, DycActAddSkuPoolRspBO.class);
    }

    @Override
    public RspPage<ActSkuPoolBO> querySkuPoolPageList(ActSkuPoolReqBO actSkuPoolReqBO) {
        return this.dycActSkuPoolRepository.querySkuPoolPageList(actSkuPoolReqBO);
    }

    @Override
    public ActSkuPoolRspBO deleteActSkuPool(ActSkuPoolReqBO actSkuPoolReqBO) {
        return this.dycActSkuPoolRepository.deleteActSkuPool(actSkuPoolReqBO);
    }

    @Override
    public ActSkuPoolRspBO modifySkuPool(ActSkuPoolReqBO reqBO) {
        return this.dycActSkuPoolRepository.updateActSkuPool(reqBO);
    }

    @Override
    public ActRelSkuPoolListRspBO batchInsertActRelSkuPool(List<ActRelSkuPoolReqBO> actRelSkuPoolReqBO) {
        return this.dycActRelSkuPoolRepository.addListActRelSkuPool(actRelSkuPoolReqBO);
    }

    @Override
    public ActRelSourcePoolListRspBO batchInsertActRelSourcePool(List<ActRelSourcePoolReqBO> actRelSourcePoolReqBO) {
        return this.dycActRelSourcePoolRepository.addListActRelSourcePool(actRelSourcePoolReqBO);
    }

    @Override
    public ActRelSkuPoolRspBO batchDeleteActRelSkuPool(ActRelSkuPoolReqBO actRelSkuPoolReqBO) {
        return this.dycActRelSkuPoolRepository.deleteListActRelSkuPool(actRelSkuPoolReqBO);
    }

    @Override
    public ActRelSourcePoolRspBO batchDeleteActRelSourcePool(ActRelSourcePoolReqBO actRelSourcePoolReqBO) {
        return this.dycActRelSourcePoolRepository.deleteListActRelSourcePool(actRelSourcePoolReqBO);
    }

    @Override
    public ActSkuPoolListRspBO queryActSkuPoolList(ActSkuPoolReqBO actSkuPoolReqBO) {
        return this.dycActSkuPoolRepository.queryActSkuPoolList(actSkuPoolReqBO);
    }

    @Override
    public RspPage<ActRelSourcePoolBO> querySkuPoolRelPageListBySup(ActRelSourcePoolReqBO sourcePoolReqBO) {
        if (!DycActivityConstants.PoolType.SUPPLIER.equals(sourcePoolReqBO.getPoolType())) {
            throw new ZTBusinessException("\u53ea\u80fd\u67e5\u8be2\u4f9b\u5e94\u5546\u7c7b\u578b\u7684\u5546\u54c1\u6c60");
        }
        RspPage<ActRelSourcePoolBO> rspPage = this.dycActRelSourcePoolRepository.queryActRelSourcePoolListPage(sourcePoolReqBO);
        if (rspPage.getRecordsTotal() > 0) {
            List<Long> sourceIds = rspPage.getRows().stream().map(ActRelSourcePoolBO::getSourceId).collect(Collectors.toList());
            Map<Long, Integer> skuNumBySource = this.getSkuNumMap(sourcePoolReqBO.getPoolType(), sourceIds, sourcePoolReqBO.getPoolId());
            ActSkuVendorReqBO vendorReqBO = new ActSkuVendorReqBO();
            vendorReqBO.setVendorIdList(sourceIds);
            List<ActSkuVendorBO> data = this.dycActSkuVendorRepository.queryActSkuVendorList(vendorReqBO).getData();
            Map<Object, Object> sourceNameBySource = new HashMap();
            if (!CollectionUtils.isEmpty(data)) {
                sourceNameBySource = data.stream().collect(Collectors.toMap(ActSkuVendorBO::getVendorId, ActSkuVendorBO::getVendorName));
            }
            for (ActRelSourcePoolBO sourcePoolBO : rspPage.getRows()) {
                if (skuNumBySource.containsKey(sourcePoolBO.getSourceId())) {
                    sourcePoolBO.setSkuNum(skuNumBySource.get(sourcePoolBO.getSourceId()));
                }
                if (!sourceNameBySource.containsKey(sourcePoolBO.getSourceId())) continue;
                sourcePoolBO.setSourceName((String)sourceNameBySource.get(sourcePoolBO.getSourceId()));
            }
        }
        return rspPage;
    }

    @Override
    public RspPage<ActRelSourcePoolBO> querySkuPoolRelPageListByCatalog(ActRelSourcePoolReqBO sourcePoolReqBO) {
        if (!DycActivityConstants.PoolType.CATALOG.equals(sourcePoolReqBO.getPoolType())) {
            throw new ZTBusinessException("\u53ea\u80fd\u67e5\u8be2\u5546\u54c1\u7c7b\u76ee\u7c7b\u578b\u7684\u5546\u54c1\u6c60");
        }
        RspPage<ActRelSourcePoolBO> rspPage = this.dycActRelSourcePoolRepository.queryActRelSourcePoolListPage(sourcePoolReqBO);
        if (rspPage.getRecordsTotal() > 0) {
            List<Long> sourceIds = rspPage.getRows().stream().map(ActRelSourcePoolBO::getSourceId).collect(Collectors.toList());
            Map<Long, Integer> skuNumBySource = this.getSkuNumMap(sourcePoolReqBO.getPoolType(), sourceIds, sourcePoolReqBO.getPoolId());
            ActSkuGuideReqBO guideReqBO = new ActSkuGuideReqBO();
            guideReqBO.setGuideCatalogIdList(sourceIds);
            Map<Long, ActSkuGuideBO> catalogBOByCatalogIds = this.dycActSkuGuideRepository.getCatalogBOByCatalogIds(guideReqBO).getCatalogBOByCatalogIds();
            for (ActRelSourcePoolBO sourcePoolBO : rspPage.getRows()) {
                if (skuNumBySource.containsKey(sourcePoolBO.getSourceId())) {
                    sourcePoolBO.setSkuNum(skuNumBySource.get(sourcePoolBO.getSourceId()));
                }
                if (!catalogBOByCatalogIds.containsKey(sourcePoolBO.getSourceId())) continue;
                sourcePoolBO.setSourceName(catalogBOByCatalogIds.get(sourcePoolBO.getSourceId()).getCatalogFullName());
            }
        }
        return rspPage;
    }

    @Override
    public ActRelSourcePoolListRspBO queryActRelSourcePoolList(ActRelSourcePoolReqBO actRelSourcePoolReqBO) {
        return this.dycActRelSourcePoolRepository.queryActRelSourcePoolList(actRelSourcePoolReqBO);
    }

    @Override
    public ActRelSkuPoolListRspBO queryActRelSkuPoolList(ActRelSkuPoolReqBO actRelSkuPoolReqBO) {
        return this.dycActRelSkuPoolRepository.queryActRelSkuPoolList(actRelSkuPoolReqBO);
    }

    @Override
    public ActRelSkuPoolRspBO addActRelSkuPool(ActRelSkuPoolReqBO actRelSkuPoolReqBO) {
        return this.dycActRelSkuPoolRepository.addActRelSkuPool(actRelSkuPoolReqBO);
    }

    private Map<Long, Integer> getSkuNumMap(Integer poolType, List<Long> sourceIds, Long poolId) {
        ActRelSourcePoolReqBO poolReqBO = new ActRelSourcePoolReqBO();
        poolReqBO.setPoolId(poolId);
        poolReqBO.setPoolType(poolType);
        poolReqBO.setSourceIdList(sourceIds);
        return this.dycActRelSourcePoolRepository.getSkuNumBySource(poolReqBO);
    }
}

